/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model.query;

import io.goodforgod.api.etherscan.error.EtherScanLogQueryException;
import io.goodforgod.api.etherscan.model.query.LogQuery;
import io.goodforgod.api.etherscan.model.query.LogQueryImpl;
import io.goodforgod.api.etherscan.model.query.LogTopicBuilder;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LogTopicSingle
implements LogTopicBuilder {
    private final String address;
    private final long startBlock;
    private final long endBlock;
    private final String topic0;

    LogTopicSingle(String address, long startBlock, long endBlock, String topic0) {
        this.address = address;
        this.startBlock = startBlock;
        this.endBlock = endBlock;
        this.topic0 = topic0;
    }

    @Override
    @NotNull
    public LogQuery build() throws EtherScanLogQueryException {
        return new LogQueryImpl("&address=" + this.address + "&fromBlock=" + this.startBlock + "&toBlock=" + this.endBlock + "&topic0=" + this.topic0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogTopicSingle that = (LogTopicSingle)o;
        return this.startBlock == that.startBlock && this.endBlock == that.endBlock && Objects.equals(this.address, that.address) && Objects.equals(this.topic0, that.topic0);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.startBlock, this.endBlock, this.topic0);
    }

    public String toString() {
        return "LogTopicSingle{address=" + this.address + "', startBlock=" + this.startBlock + ", endBlock=" + this.endBlock + ", topic0=" + this.topic0 + "'}";
    }
}

