/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model.query;

import io.goodforgod.api.etherscan.error.EtherScanLogQueryException;
import io.goodforgod.api.etherscan.model.query.LogOp;
import io.goodforgod.api.etherscan.model.query.LogQuery;
import io.goodforgod.api.etherscan.model.query.LogQueryImpl;
import io.goodforgod.api.etherscan.model.query.LogTopicBuilder;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LogTopicTuple
implements LogTopicBuilder {
    private final String address;
    private final long startBlock;
    private final long endBlock;
    private final String topic0;
    private final String topic1;
    private LogOp topic0_1_opr;

    LogTopicTuple(String address, long startBlock, long endBlock, String topic0, String topic1) {
        this.address = address;
        this.startBlock = startBlock;
        this.endBlock = endBlock;
        this.topic0 = topic0;
        this.topic1 = topic1;
    }

    public LogTopicTuple setOpTopic0_1(LogOp topic0_1_opr) {
        this.topic0_1_opr = topic0_1_opr;
        return this;
    }

    @Override
    @NotNull
    public LogQuery build() throws EtherScanLogQueryException {
        if (this.topic0_1_opr == null) {
            throw new EtherScanLogQueryException("topic0_1_opr can not be null.");
        }
        return new LogQueryImpl("&address=" + this.address + "&fromBlock=" + this.startBlock + "&toBlock=" + this.endBlock + "&topic0=" + this.topic0 + "&topic1=" + this.topic1 + "&topic0_1_opr=" + this.topic0_1_opr.getOperation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogTopicTuple that = (LogTopicTuple)o;
        return this.startBlock == that.startBlock && this.endBlock == that.endBlock && Objects.equals(this.address, that.address) && Objects.equals(this.topic0, that.topic0) && Objects.equals(this.topic1, that.topic1) && this.topic0_1_opr == that.topic0_1_opr;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.startBlock, this.endBlock, this.topic0, this.topic1, this.topic0_1_opr});
    }

    public String toString() {
        return "LogTopicTuple{address=" + this.address + "', startBlock=" + this.startBlock + ", endBlock=" + this.endBlock + ", topic0=" + this.topic0 + "', topic1=" + this.topic1 + "', topic0_1_opr=" + String.valueOf((Object)this.topic0_1_opr) + "}";
    }
}

