/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.AudioFrame;
import com.github.hoary.javaav.SampleFormat;
import com.googlecode.javacpp.BytePointer;
import java.nio.ByteBuffer;

public class Audio {
    private static final float twoPower7 = 128.0f;
    private static final float twoPower15 = 32768.0f;
    private static final float twoPower23 = 8388608.0f;
    private static final float twoPower31 = 2.1474836E9f;

    public static int getFormatDepth(SampleFormat format) {
        switch (format) {
            case U8: 
            case U8P: {
                return 1;
            }
            case S16: 
            case S16P: {
                return 2;
            }
            case S32: 
            case S32P: {
                return 4;
            }
            case FLT: 
            case FLTP: {
                return 4;
            }
            case DBL: 
            case DBLP: {
                return 8;
            }
        }
        return 0;
    }

    public static Number getValue(ByteBuffer buffer, SampleFormat format, int index) {
        switch (format) {
            case U8: 
            case U8P: {
                return buffer.get(index);
            }
            case S16: 
            case S16P: {
                return buffer.getShort(index);
            }
            case S32: 
            case S32P: {
                return buffer.getInt(index);
            }
            case FLT: 
            case FLTP: {
                return Float.valueOf(buffer.getFloat(index));
            }
            case DBL: 
            case DBLP: {
                return buffer.getDouble(index);
            }
        }
        return 0;
    }

    public static byte[] getAudio8(AudioFrame frame) {
        BytePointer[] planes = frame.getPlanes();
        SampleFormat format = frame.getAudioFormat().getSampleFormat();
        int depth = Audio.getFormatDepth(format);
        int length = planes[0].limit() / depth;
        int channels = planes.length;
        byte[] samples = new byte[channels * length];
        for (int i = 0; i < channels; ++i) {
            ByteBuffer buffer = planes[i].asByteBuffer();
            int offset = i * channels;
            int k = offset;
            for (int j = 0; j < length; ++j) {
                long sample = Audio.quantize8(Audio.getValue(buffer, format, j * depth).doubleValue() * 128.0);
                samples[k++] = (byte)(sample & 0x80L);
                k += 2 * (channels - 1);
            }
        }
        return samples;
    }

    public static byte[] getAudio16(AudioFrame frame) {
        BytePointer[] planes = frame.getPlanes();
        SampleFormat format = frame.getAudioFormat().getSampleFormat();
        int depth = Audio.getFormatDepth(format);
        int length = planes[0].limit() / depth;
        int channels = planes.length;
        byte[] samples = new byte[channels * length * 2];
        for (int i = 0; i < channels; ++i) {
            ByteBuffer buffer = planes[i].asByteBuffer();
            int offset = i * channels;
            int k = offset;
            for (int j = 0; j < length; ++j) {
                long sample = Audio.quantize16(Audio.getValue(buffer, format, j * depth).doubleValue() * 32768.0);
                samples[k++] = (byte)(sample & 0xFFL);
                samples[k++] = (byte)(sample >> 8 & 0xFFL);
                k += 2 * (channels - 1);
            }
        }
        return samples;
    }

    public static byte[] getAudio24(AudioFrame frame) {
        BytePointer[] planes = frame.getPlanes();
        SampleFormat format = frame.getAudioFormat().getSampleFormat();
        int depth = Audio.getFormatDepth(format);
        int length = planes[0].limit() / depth;
        int channels = planes.length;
        byte[] samples = new byte[channels * length * 3];
        for (int i = 0; i < channels; ++i) {
            ByteBuffer buffer = planes[i].asByteBuffer();
            int offset = i * channels;
            int k = offset;
            for (int j = 0; j < length; ++j) {
                long sample = Audio.quantize24(Audio.getValue(buffer, format, j * depth).doubleValue() * 8388608.0);
                samples[k++] = (byte)(sample & 0xFFL);
                samples[k++] = (byte)(sample >> 8 & 0xFFL);
                samples[k++] = (byte)(sample >> 16 & 0xFFL);
                k += 2 * (channels - 1);
            }
        }
        return samples;
    }

    public static byte[] getAudio32(AudioFrame frame) {
        BytePointer[] planes = frame.getPlanes();
        SampleFormat format = frame.getAudioFormat().getSampleFormat();
        int depth = Audio.getFormatDepth(format);
        int length = planes[0].limit() / depth;
        int channels = planes.length;
        byte[] samples = new byte[channels * length * 4];
        for (int i = 0; i < channels; ++i) {
            ByteBuffer buffer = planes[i].asByteBuffer();
            int offset = i * channels;
            int k = offset;
            for (int j = 0; j < length; ++j) {
                long sample = Audio.quantize32(Audio.getValue(buffer, format, j * depth).doubleValue() * 2.147483648E9);
                samples[k++] = (byte)(sample & 0xFFL);
                samples[k++] = (byte)(sample >> 8 & 0xFFL);
                samples[k++] = (byte)(sample >> 16 & 0xFFL);
                samples[k++] = (byte)(sample >> 24 & 0xFFL);
                k += 2 * (channels - 1);
            }
        }
        return samples;
    }

    private static byte quantize8(double sample) {
        if (sample >= 127.0) {
            return 127;
        }
        if (sample <= -128.0) {
            return -128;
        }
        return (byte)(sample < 0.0 ? sample - 0.5 : sample + 0.5);
    }

    private static int quantize16(double sample) {
        if (sample >= 32767.0) {
            return Short.MAX_VALUE;
        }
        if (sample <= -32768.0) {
            return Short.MIN_VALUE;
        }
        return (int)(sample < 0.0 ? sample - 0.5 : sample + 0.5);
    }

    private static int quantize24(double sample) {
        if (sample >= 8388607.0) {
            return 0x7FFFFF;
        }
        if (sample <= -8388608.0) {
            return -8388608;
        }
        return (int)(sample < 0.0 ? sample - 0.5 : sample + 0.5);
    }

    private static int quantize32(double sample) {
        if (sample >= 2.147483648E9) {
            return Integer.MAX_VALUE;
        }
        if (sample <= -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)(sample < 0.0 ? sample - 0.5 : sample + 0.5);
    }
}

