/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.AudioFormat;
import com.github.hoary.javaav.AudioFrame;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.RingBuffer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacv.cpp.avutil;
import com.googlecode.javacv.cpp.swresample;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class AudioResampler {
    private swresample.SwrContext convertContext;
    private RingBuffer buffer;
    private int frameSamples;
    private AudioFormat srcFormat;
    private AudioFormat dstFormat;

    public void open(AudioFormat srcFormat, AudioFormat dstFormat, int frameSamples) throws JavaAVException {
        if (srcFormat == null) {
            throw new JavaAVException("Invalid input audio format provided: " + srcFormat);
        }
        if (dstFormat == null) {
            throw new JavaAVException("Invalid output audio format provided: " + dstFormat);
        }
        if (srcFormat.equals(dstFormat)) {
            return;
        }
        this.srcFormat = srcFormat;
        this.dstFormat = dstFormat;
        this.frameSamples = frameSamples;
        this.convertContext = swresample.swr_alloc();
        if (this.convertContext == null) {
            throw new JavaAVException("Could not allocate the audio conversion context.");
        }
        long dstChannelLayout = dstFormat.getChannelLayout().value();
        long srcChannelLayout = srcFormat.getChannelLayout().value();
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"ocl", (long)dstChannelLayout, (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"osf", (long)dstFormat.getSampleFormat().value(), (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"osr", (long)dstFormat.getSampleRate(), (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"icl", (long)srcChannelLayout, (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"isf", (long)srcFormat.getSampleFormat().value(), (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"isr", (long)srcFormat.getSampleRate(), (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"tsf", (long)-1L, (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"ich", (long)avutil.av_get_channel_layout_nb_channels((long)srcChannelLayout), (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"och", (long)avutil.av_get_channel_layout_nb_channels((long)dstChannelLayout), (int)0);
        avutil.av_opt_set_int((Pointer)this.convertContext, (String)"uch", (long)0L, (int)0);
        if (swresample.swr_init((swresample.SwrContext)this.convertContext) < 0) {
            throw new JavaAVException("Could not initialize the conversion context.");
        }
        this.buffer = new RingBuffer(1024000, dstFormat.getChannels());
    }

    public AudioFrame[] resample(AudioFrame frame) {
        ArrayList<AudioFrame> frames = new ArrayList<AudioFrame>();
        int outputChannels = this.dstFormat.getChannels();
        int outputRate = this.dstFormat.getSampleRate();
        int outputFormat = this.dstFormat.getSampleFormat().value();
        int inputRate = this.srcFormat.getSampleRate();
        int planes = avutil.av_sample_fmt_is_planar((int)outputFormat) != 0 ? outputChannels : 1;
        int destSamples = Math.max(this.frameSamples, (int)avutil.av_rescale_rnd((long)this.frameSamples, (long)outputRate, (long)inputRate, (int)2));
        AudioFrame tempFrame = new AudioFrame(this.dstFormat, destSamples * 4);
        int inSamples = 0;
        int outSamples = this.frameSamples * 4;
        PointerPointer inPointer = null;
        if (frame != null) {
            inSamples = frame.getSampleCount();
            inPointer = frame.getData();
        }
        if (outSamples <= 0) {
            outSamples = inSamples;
        }
        int resampled = swresample.swr_convert((swresample.SwrContext)this.convertContext, (PointerPointer)tempFrame.getData(), (int)outSamples, (PointerPointer)inPointer, (int)inSamples);
        int limit = resampled * outputChannels * avutil.av_get_bytes_per_sample((int)outputFormat) / planes;
        for (int i = 0; i < tempFrame.getPlaneCount(); ++i) {
            ByteBuffer buf = tempFrame.getPlane(i).asByteBuffer();
            buf.limit(Math.min(limit, buf.capacity()));
            this.buffer.write(i, buf);
        }
        int bufferSize = destSamples * outputChannels * avutil.av_get_bytes_per_sample((int)outputFormat) / planes;
        while (this.buffer.available() >= bufferSize) {
            AudioFrame outFrame = new AudioFrame(this.dstFormat, destSamples);
            for (int i = 0; i < planes; ++i) {
                byte[] data = new byte[bufferSize];
                try {
                    this.buffer.read(i, data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                outFrame.getPlane(i).position(0).put(data);
            }
            outFrame.setSampleCount(this.frameSamples);
            frames.add(outFrame);
        }
        return frames.toArray(new AudioFrame[0]);
    }

    public void close() {
        if (this.convertContext != null) {
            swresample.swr_free((swresample.SwrContext)this.convertContext);
            this.convertContext = null;
        }
    }
}

