/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.CameraFormat;
import com.github.hoary.javaav.JavaAV;
import com.github.hoary.javaav.LogCallback;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.cpp.avformat;
import com.googlecode.javacv.cpp.avutil;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CameraCapabilities {
    private static Pattern resPattern = Pattern.compile("(\\d{1,4})x(\\d{1,4})");
    private static Pattern fpsPattern = Pattern.compile("max .* fps=(\\d{1,4})");

    public static CameraFormat[] probeResolutions(String source, String option, String device) {
        final TreeSet set = new TreeSet();
        LogCallback callback = new LogCallback(){

            public void call(Pointer source, int level, String formatStr, Pointer params) {
                byte[] bytes = new byte[1024];
                avutil.av_log_format_line((Pointer)source, (int)level, (String)formatStr, (Pointer)params, (byte[])bytes, (int)bytes.length, (int[])new int[]{0});
                String message = new String(bytes).trim();
                Matcher resMatcher = resPattern.matcher(message);
                CameraFormat format = new CameraFormat();
                while (resMatcher.find()) {
                    String[] parts = resMatcher.group(0).split("x");
                    format.setWidth(Integer.parseInt(parts[0]));
                    format.setHeight(Integer.parseInt(parts[1]));
                }
                resMatcher = fpsPattern.matcher(message);
                if (resMatcher.find()) {
                    format.setFrameRate(Integer.parseInt(resMatcher.group(1)));
                }
                if (format.isValid() && !set.add(format)) {
                    Iterator iter = set.iterator();
                    while (iter.hasNext()) {
                        CameraFormat f = (CameraFormat)iter.next();
                        if (f.compareTo(format) != 0 || !(f.getFrameRate() < format.getFrameRate())) continue;
                        iter.remove();
                        set.add(format);
                        break;
                    }
                }
            }
        };
        JavaAV.loadLibrary();
        JavaAV.setLogCallback(callback);
        avformat.AVFormatContext context = new avformat.AVFormatContext(null);
        avutil.AVDictionary dict = new avutil.AVDictionary(null);
        avutil.av_dict_set((avutil.AVDictionary)dict, (String)option, (String)"true", (int)0);
        avformat.AVInputFormat inputFormat = avformat.av_find_input_format((String)source);
        avformat.avformat_open_input((avformat.AVFormatContext)context, (String)("video=" + device), (avformat.AVInputFormat)inputFormat, (avutil.AVDictionary)dict);
        if (context != null && !context.isNull()) {
            avformat.avformat_close_input((avformat.AVFormatContext)context);
        }
        JavaAV.setLogCallback(new LogCallback());
        return set.toArray(new CameraFormat[0]);
    }
}

