/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.Codec;
import com.github.hoary.javaav.CodecFlag;
import com.github.hoary.javaav.Configurable;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.MediaType;
import com.github.hoary.javaav.PixelFormat;
import com.github.hoary.javaav.SampleFormat;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avutil;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Coder
extends Configurable {
    private static final Logger logger = LogManager.getLogger((String)Coder.class.getName());
    protected int[] gotFrame = new int[1];
    protected avcodec.AVCodecContext avContext;
    protected avutil.AVFrame avFrame;
    protected avcodec.AVPacket avPacket;
    protected final Codec codec;
    protected State state;

    Coder(Codec codec, avcodec.AVCodecContext avContext) {
        this.codec = codec;
        this.avContext = avContext;
        this.state = State.Closed;
    }

    public void open(Map<String, String> options) throws JavaAVException {
        if (this.state == State.Opened) {
            logger.warn("Trying to open an already opened Coder. Aborted.");
            return;
        }
        if (this.codec == null) {
            throw new JavaAVException("Codec is null. Aborted.");
        }
        if (this.avContext == null) {
            this.avContext = avcodec.avcodec_alloc_context3((avcodec.AVCodec)this.codec.getCodec());
        }
        if (this.avContext == null) {
            throw new JavaAVException("No codec context available for codec " + this.codec.getName());
        }
        if (this.pixelFormat != null) {
            this.avContext.pix_fmt(this.pixelFormat.value());
        }
        if (this.sampleFormat != null) {
            int sampleBitSize = avutil.av_get_bytes_per_sample((int)this.sampleFormat.value()) * 8;
            this.avContext.sample_fmt(this.sampleFormat.value());
            this.avContext.bits_per_raw_sample(sampleBitSize);
        }
        if (this.imageWidth > 0) {
            this.avContext.width(this.imageWidth);
        }
        if (this.imageHeight > 0) {
            this.avContext.height(this.imageHeight);
        }
        if (this.gopSize > 0) {
            this.avContext.gop_size(this.gopSize);
        }
        if (this.audioChannels > 0) {
            this.avContext.channels(this.audioChannels);
            this.avContext.channel_layout(avutil.av_get_default_channel_layout((int)this.audioChannels));
        }
        if (this.sampleRate > 0) {
            this.avContext.sample_rate(this.sampleRate);
            this.avContext.time_base().num(1).den(this.sampleRate);
        }
        if (this.frameRate > 0.0) {
            this.avContext.time_base(avutil.av_inv_q((avutil.AVRational)avutil.av_d2q((double)this.frameRate, (int)1001000)));
        }
        if (this.bitrate > 0) {
            this.avContext.bit_rate(this.bitrate);
        }
        if (this.profile > 0) {
            this.avContext.profile(this.profile);
        }
        if (this.quality > -10.0) {
            this.avContext.flags(this.avContext.flags() | 2);
            this.avContext.global_quality((int)Math.round(118.0 * this.quality));
        }
        for (CodecFlag flag : this.flags) {
            this.avContext.flags(this.avContext.flags() | flag.value());
        }
        avutil.AVDictionary avDictionary = new avutil.AVDictionary(null);
        if (this.getQuality() >= 0.0) {
            avutil.av_dict_set((avutil.AVDictionary)avDictionary, (String)"crf", (String)(this.getQuality() + ""), (int)0);
        }
        if (options != null) {
            for (Map.Entry<String, String> e : options.entrySet()) {
                avutil.av_dict_set((avutil.AVDictionary)avDictionary, (String)e.getKey(), (String)e.getValue(), (int)0);
            }
        }
        if (this.codec.open(avDictionary, this.avContext) < 0) {
            throw new JavaAVException("Could not open codec.");
        }
        avutil.av_dict_free((avutil.AVDictionary)avDictionary);
        this.avFrame = avcodec.avcodec_alloc_frame();
        if (this.avFrame == null) {
            throw new JavaAVException("Could not allocate frame.");
        }
        this.avPacket = new avcodec.AVPacket();
        this.state = State.Opened;
    }

    public void close() {
        if (this.avFrame != null) {
            avcodec.avcodec_free_frame((avutil.AVFrame)this.avFrame);
            this.avFrame = null;
        }
        if (this.avContext != null && !this.avContext.isNull()) {
            avcodec.avcodec_close((avcodec.AVCodecContext)this.avContext);
            if (this.avContext.extradata() != null) {
                avutil.av_free((Pointer)this.avContext.extradata());
            }
            avutil.av_free((Pointer)this.avContext);
            this.avContext = null;
        }
        this.state = State.Closed;
    }

    public void flush() {
        if (this.avContext == null) {
            return;
        }
        avcodec.avcodec_flush_buffers((avcodec.AVCodecContext)this.avContext);
    }

    @Override
    public MediaType getMediaType() {
        if (this.avContext != null) {
            return MediaType.byId(this.avContext.codec_type());
        }
        return super.getMediaType();
    }

    @Override
    public int getImageWidth() {
        if (this.avContext != null) {
            return this.avContext.width();
        }
        return super.getImageWidth();
    }

    @Override
    public int getImageHeight() {
        if (this.avContext != null) {
            return this.avContext.height();
        }
        return super.getImageHeight();
    }

    @Override
    public int getGOPSize() {
        if (this.avContext != null) {
            return this.avContext.gop_size();
        }
        return super.getGOPSize();
    }

    @Override
    public PixelFormat getPixelFormat() {
        if (this.avContext != null) {
            return PixelFormat.byId(this.avContext.pix_fmt());
        }
        return super.getPixelFormat();
    }

    @Override
    public SampleFormat getSampleFormat() {
        if (this.avContext != null) {
            return SampleFormat.byId(this.avContext.sample_fmt());
        }
        return super.getSampleFormat();
    }

    @Override
    public int getBitrate() {
        if (this.avContext != null) {
            return this.avContext.bit_rate();
        }
        return super.getBitrate();
    }

    @Override
    public double getFramerate() {
        if (this.avContext != null) {
            return avutil.av_q2d((avutil.AVRational)this.avContext.time_base());
        }
        return super.getFramerate();
    }

    @Override
    public int getSampleRate() {
        if (this.avContext != null) {
            return this.avContext.sample_rate();
        }
        return super.getSampleRate();
    }

    @Override
    public int getAudioChannels() {
        if (this.avContext != null) {
            return this.avContext.channels();
        }
        return super.getAudioChannels();
    }

    @Override
    public double getQuality() {
        if (this.avContext != null) {
            return Math.round(this.avContext.global_quality() / 118);
        }
        return super.getQuality();
    }

    @Override
    public int getProfile() {
        if (this.avContext != null) {
            return this.avContext.profile();
        }
        return super.getProfile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Closed,
        Opened;

    }
}

