/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.CodecFlag;
import com.github.hoary.javaav.JavaAV;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.MediaType;
import com.github.hoary.javaav.PixelFormat;
import com.github.hoary.javaav.SampleFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class Configurable {
    protected MediaType mediaType;
    protected PixelFormat pixelFormat;
    protected SampleFormat sampleFormat;
    protected int imageWidth;
    protected int imageHeight;
    protected int gopSize;
    protected int audioChannels;
    protected int sampleRate;
    protected int bitrate;
    protected int profile;
    protected double frameRate;
    protected double quality = -1.0;
    protected List<CodecFlag> flags = new ArrayList<CodecFlag>();

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType type) {
        this.mediaType = type;
    }

    public void setImageWidth(int width) throws JavaAVException {
        this.imageWidth = width;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageHeight(int height) throws JavaAVException {
        this.imageHeight = height;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setGOPSize(int size) throws JavaAVException {
        this.gopSize = size;
    }

    public int getGOPSize() {
        return this.gopSize;
    }

    public void setPixelFormat(PixelFormat pixelFormat) throws JavaAVException {
        this.pixelFormat = pixelFormat;
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public void setSampleFormat(SampleFormat sampleFormat) throws JavaAVException {
        this.sampleFormat = sampleFormat;
    }

    public SampleFormat getSampleFormat() {
        return this.sampleFormat;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setFramerate(double framerate) throws JavaAVException {
        this.frameRate = framerate;
    }

    public double getFramerate() {
        return this.frameRate;
    }

    public void setSamplerate(int samplerate) {
        this.sampleRate = samplerate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setAudioChannels(int channels) {
        this.audioChannels = channels;
    }

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public void setQuality(double quality) {
        this.quality = quality;
    }

    public double getQuality() {
        return this.quality;
    }

    public void setProfile(int profile) {
        this.profile = this.bitrate;
    }

    public int getProfile() {
        return this.profile;
    }

    public void setFlag(CodecFlag flag) throws JavaAVException {
        if (flag == null) {
            throw new JavaAVException("Could not set codec flag. Null provided.");
        }
        this.flags.add(flag);
    }

    static {
        JavaAV.loadLibrary();
    }
}

