/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.LogLevel;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.cpp.avutil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogCallback
extends avutil.Arg0_Pointer_int_String_Pointer {
    private static final Logger LOGGER = LogManager.getLogger((String)LogCallback.class.getName());
    private boolean printPrefix = true;
    private LogLevel logLevel = LogLevel.INFO;

    public void call(Pointer source, int level, String formatStr, Pointer params) {
        if (this.logLevel.value() < level) {
            return;
        }
        byte[] bytes = new byte[1024];
        int prefix = this.printPrefix ? 1 : 0;
        avutil.av_log_format_line((Pointer)source, (int)level, (String)formatStr, (Pointer)params, (byte[])bytes, (int)bytes.length, (int[])new int[]{prefix});
        String message = new String(bytes).trim();
        switch (this.logLevel) {
            case PANIC: 
            case FATAL: 
            case ERROR: {
                LOGGER.error(message);
                break;
            }
            case WARNING: {
                LOGGER.warn(message);
                break;
            }
            case INFO: {
                LOGGER.info(message);
                break;
            }
            case VERBOSE: 
            case DEBUG: {
                LOGGER.debug(message);
                break;
            }
        }
    }

    public void setPrintPrefix(boolean printPrefix) {
        this.printPrefix = printPrefix;
    }

    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }
}

