/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import java.io.IOException;
import java.nio.ByteBuffer;

public class RingBuffer {
    private ByteBuffer[] buffer;
    private int[] readPointer;
    private int[] writePointer;
    private int[] bytesToWrite;
    private int[] bytesToRead;
    private int planes;

    public RingBuffer(int planes) {
        this(1024, planes);
    }

    public RingBuffer(int capacity, int planes) {
        if (capacity < 2) {
            throw new IllegalArgumentException("Buffer should have at least the capacity of 2 bytes.");
        }
        this.planes = planes;
        this.buffer = new ByteBuffer[planes];
        this.readPointer = new int[planes];
        this.writePointer = new int[planes];
        this.bytesToRead = new int[planes];
        this.bytesToWrite = new int[planes];
        for (int i = 0; i < planes; ++i) {
            this.buffer[i] = ByteBuffer.allocateDirect(capacity);
        }
        this.clear();
    }

    public synchronized void clear() {
        for (int i = 0; i < this.planes; ++i) {
            this.writePointer[i] = 0;
            this.readPointer[i] = 0;
            this.bytesToRead[i] = 0;
            this.bytesToWrite[i] = this.buffer[i].capacity();
        }
    }

    public int available() {
        return this.bytesToRead[0];
    }

    public synchronized int write(int plane, ByteBuffer buffer) {
        byte[] data = new byte[buffer.limit()];
        buffer.get(data);
        return this.write(plane, data);
    }

    public synchronized int write(int plane, byte[] data) {
        return this.write(plane, data, 0, data.length);
    }

    public synchronized int write(int plane, byte[] data, int offset, int length) {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bytesToWrite[plane] == 0) {
            return 0;
        }
        if (this.bytesToWrite[plane] < length) {
            length = this.bytesToWrite[plane];
        }
        this.buffer[plane].position(this.writePointer[plane]);
        int partLength = this.buffer[plane].capacity() - this.writePointer[plane];
        if (partLength > length) {
            this.buffer[plane].put(data, offset, length);
            int n = plane;
            this.writePointer[n] = this.writePointer[n] + length;
        } else {
            this.buffer[plane].put(data, offset, partLength);
            this.buffer[plane].position(0);
            this.buffer[plane].put(data, offset + partLength, length - partLength);
            this.writePointer[plane] = length - partLength;
        }
        int n = plane;
        this.bytesToRead[n] = this.bytesToRead[n] + length;
        int n2 = plane;
        this.bytesToWrite[n2] = this.bytesToWrite[n2] - length;
        return length;
    }

    public synchronized int read(int plane, byte[] data) throws IOException {
        return this.read(plane, data, 0, data.length);
    }

    public synchronized int read(int plane, byte[] data, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bytesToRead[plane] == 0) {
            return 0;
        }
        if (this.bytesToRead[plane] < length) {
            length = this.bytesToRead[plane];
        }
        this.buffer[plane].position(this.readPointer[plane]);
        int partLength = this.buffer[plane].capacity() - this.readPointer[plane];
        if (partLength > length) {
            this.buffer[plane].get(data, offset, length);
            int n = plane;
            this.readPointer[n] = this.readPointer[n] + length;
        } else {
            this.buffer[plane].get(data, offset, partLength);
            this.buffer[plane].position(0);
            this.buffer[plane].get(data, partLength, length - partLength);
            this.readPointer[plane] = length - partLength;
        }
        int n = plane;
        this.bytesToRead[n] = this.bytesToRead[n] - length;
        int n2 = plane;
        this.bytesToWrite[n2] = this.bytesToWrite[n2] + length;
        return length;
    }
}

