/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.Image;
import com.github.hoary.javaav.MediaFrame;
import com.github.hoary.javaav.PictureFormat;
import com.github.hoary.javaav.PixelFormat;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;

public class VideoFrame
extends MediaFrame {
    private ByteBuffer data;
    private PixelFormat format;
    private int width;
    private int height;

    public VideoFrame() {
        this(null, 0, 0, null);
    }

    public VideoFrame(ByteBuffer data, int width, int height, PixelFormat format) {
        this.data = data;
        this.width = width;
        this.height = height;
        this.format = format;
    }

    public static VideoFrame create(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        PixelFormat format = Image.getPixelFormat(image);
        return new VideoFrame(Image.createImageBuffer(image), width, height, format);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public PixelFormat getPixelFormat() {
        return this.format;
    }

    public PictureFormat getPictureFormat() {
        return new PictureFormat(this.width, this.height, this.format);
    }

    public MediaFrame.Type getType() {
        return MediaFrame.Type.VIDEO;
    }

    public boolean hasFrame() {
        return this.data != null && this.data.capacity() > 1;
    }
}

