/*
 * Decompiled with CFR 0.152.
 */
package com.github.iamiddy.syncrest.asynchprocessor;

import com.github.iamiddy.syncrest.asynchprocessor.AbstractResponse;
import com.github.iamiddy.syncrest.asynchprocessor.ResponseObserver;
import java.util.concurrent.ConcurrentHashMap;

public class ResponseObservable {
    private boolean changed = false;
    private ConcurrentHashMap<String, ResponseObserver> obs = new ConcurrentHashMap();

    public synchronized void addObservers(ResponseObserver ro) {
        if (ro == null || ro.getEventId() == null) {
            throw new NullPointerException();
        }
        if (this.obs.containsKey(ro.getEventId())) {
            throw new IllegalStateException("Only one observer is allowed per request : " + ro.getEventId());
        }
        this.obs.putIfAbsent(ro.getEventId(), ro);
    }

    public synchronized void deleteObserver(ResponseObserver ro) {
        if (ro == null || ro.getEventId() == null) {
            return;
        }
        this.obs.remove(ro.getEventId(), ro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractResponse> void notifyObservers(T r) {
        ResponseObserver localRo;
        ResponseObservable responseObservable = this;
        synchronized (responseObservable) {
            if (!this.changed) {
                return;
            }
            localRo = this.obs.get(r.getEventId());
            if (localRo == null) {
                this.clearChanged();
                return;
            }
            this.obs.remove(localRo.getEventId());
            this.clearChanged();
        }
        localRo.applyResponse(this, r);
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countObservers() {
        return this.obs.size();
    }
}

