/*
 * Decompiled with CFR 0.152.
 */
package com.github.iamiddy.syncrest.asynchprocessor.service;

import com.github.iamiddy.syncrest.asynchprocessor.AbstractResponse;
import com.github.iamiddy.syncrest.asynchprocessor.domain.RequestEvent;
import com.github.iamiddy.syncrest.asynchprocessor.domain.ResponseEvent;
import com.github.iamiddy.syncrest.asynchprocessor.service.MessageConsumer;
import com.github.iamiddy.syncrest.asynchprocessor.service.MessageProducer;
import java.util.concurrent.BlockingQueue;

public class SampleService
implements MessageProducer,
Runnable {
    private final BlockingQueue<ResponseEvent> responseQueue;
    private MessageConsumer consumer;

    public SampleService(BlockingQueue<ResponseEvent> responseQueue, MessageConsumer consumer) {
        this.responseQueue = responseQueue;
        this.consumer = consumer;
    }

    @Override
    public <R extends AbstractResponse> void produceMessage(R request) {
        RequestEvent ev = (RequestEvent)request;
        ResponseEvent re = new ResponseEvent(ev.getEventId(), new StringBuilder(ev.getRequestBody()).reverse().toString());
        try {
            this.responseQueue.put(re);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ResponseEvent re = this.responseQueue.take();
                    this.consumeMessage(re);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void consumeMessage(ResponseEvent re) {
        this.consumer.onMessage(re);
    }
}

