/*
 * Decompiled with CFR 0.152.
 */
package com.github.iamiddy.syncrest.asynchprocessor.service;

import com.github.iamiddy.syncrest.asynchprocessor.AbstractResponse;
import com.github.iamiddy.syncrest.asynchprocessor.ResponseObserverImpl;
import com.github.iamiddy.syncrest.asynchprocessor.service.MessageConsumer;
import com.github.iamiddy.syncrest.asynchprocessor.service.MessageProducer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SyncAsyncProcessor {
    private static SyncAsyncProcessor syncAsyncProcessorInstance = null;
    private ExecutorService executorService;
    private MessageConsumer observable;
    private MessageProducer producer;

    private SyncAsyncProcessor(MessageProducer producer, MessageConsumer messageConsumer) {
        this.producer = producer;
        this.observable = messageConsumer;
        this.executorService = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyncAsyncProcessor getInstance(MessageProducer producer, MessageConsumer messageConsumer) {
        Class<SyncAsyncProcessor> clazz = SyncAsyncProcessor.class;
        synchronized (SyncAsyncProcessor.class) {
            if (syncAsyncProcessorInstance == null) {
                syncAsyncProcessorInstance = new SyncAsyncProcessor(producer, messageConsumer);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return syncAsyncProcessorInstance;
        }
    }

    public <R extends AbstractResponse, T extends AbstractResponse> T sendAndReceive(R request, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (request == null || request.getEventId() == null) {
            throw new NullPointerException();
        }
        ResponseObserverImpl callableObserver = new ResponseObserverImpl(request.getEventId());
        this.observable.addObservers(callableObserver);
        Future response = this.executorService.submit(callableObserver);
        this.producer.produceMessage(request);
        return (T)((AbstractResponse)response.get(timeout, TimeUnit.MILLISECONDS));
    }
}

