/*
 * Copyright (c) 2015 Avast a.s., www.avast.com
 */
package cz.jalasoft.net.http.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;

/**
 * TODO Add JavaDoc description of class
 *
 * @author Jan Lastovicka (lastovicka@avast.com)
 * @since 2015-02-21
 */
final class NettyChannelInitializer extends ChannelInitializer<SocketChannel> {

    private final ChannelHandler httpHandler;

    NettyChannelInitializer(ChannelHandler httpHandler) {
        this.httpHandler = httpHandler;
    }

    @Override
    protected void initChannel(SocketChannel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new HttpClientCodec());
        pipeline.addLast(new HttpObjectAggregator(123123));
        pipeline.addLast(httpHandler);
    }
}
