/*
 * Copyright (c) 2015 Avast a.s., www.avast.com
 */
package cz.jalasoft.net.http.netty;

import cz.jalasoft.net.http.HttpClient;
import cz.jalasoft.net.http.HttpPostRequest;
import cz.jalasoft.net.http.HttpResponse;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;

import java.io.IOException;

/**
 * TODO Add JavaDoc description of class
 *
 * @author Jan Lastovicka (lastovicka@avast.com)
 * @since 2015-02-21
 */
public final class NettyHttpClient implements HttpClient {

    private final Bootstrap bootstrap;

    public NettyHttpClient() {
        bootstrap = new Bootstrap();
        bootstrap
                .group(new NioEventLoopGroup())
                .channel(NioSocketChannel.class);
    }

    @Override
    public HttpResponse post(HttpPostRequest request) {
        NettyHttpResponseCollector collector = new NettyHttpResponseCollector();

        bootstrap.handler(new NettyChannelInitializer(collector));

        ChannelFuture channelFuture = bootstrap.connect(request.uri().getHost(), request.uri().getPort());
        channelFuture.syncUninterruptibly();
        Channel channel = channelFuture.channel();

        HttpRequest nettyRequest = NettyRequestFactory.getRequest(request);
        channel.writeAndFlush(nettyRequest).syncUninterruptibly();

        channel.closeFuture().syncUninterruptibly();

        FullHttpResponse nettyResponse = collector.getResponse();
        return new NettyHttpResponse(nettyResponse);
    }

    @Override
    public void close() throws IOException {
        bootstrap.group().shutdownGracefully();
    }
}
