/*
 * Copyright (c) 2015 Avast a.s., www.avast.com
 */
package cz.jalasoft.net.http.netty;

import cz.jalasoft.net.http.HttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpResponse;

import java.nio.charset.Charset;

/**
 * TODO Add JavaDoc description of class
 *
 * @author Jan Lastovicka (lastovicka@avast.com)
 * @since 2015-02-21
 */
final class NettyHttpResponse implements HttpResponse {

    private final FullHttpResponse nettyResponse;

    NettyHttpResponse(FullHttpResponse nettyResponse) {
        this.nettyResponse = nettyResponse;
    }

    @Override
    public boolean isStatusOK() {
        return getStatusCode() == HttpResponse.RESPONSE_CODE_OK;
    }

    @Override
    public int getStatusCode() {
        int code = nettyResponse.getStatus().code();
        return code;
    }

    @Override
    public String getReason() {
        return nettyResponse.getStatus().reasonPhrase();
    }

    @Override
    public byte[] getContent() {
        ByteBuf content = nettyResponse.content();
        return content.array();
    }

    @Override
    public String getContentAsString() {
        return nettyResponse.content().toString(Charset.defaultCharset());
    }
}
