/*
 * Copyright (c) 2015 Avast a.s., www.avast.com
 */
package cz.jalasoft.net.http.netty;

import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;

/**
 * TODO Add JavaDoc description of class
 *
 * @author Jan Lastovicka (lastovicka@avast.com)
 * @since 2015-02-21
 */
final class NettyHttpResponseCollector extends ChannelHandlerAdapter {

    private FullHttpResponse nettyRespose;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpResponse response = (FullHttpResponse) msg;

        try {
            nettyRespose = response.copy();
        } finally {
            response.release();
        }

        ctx.close();
    }

    FullHttpResponse getResponse() {
        return nettyRespose;
    }
}
