/*
 * Copyright (c) 2015 Avast a.s., www.avast.com
 */
package cz.jalasoft.net.http.netty;

import cz.jalasoft.net.http.HttpPostRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.*;

/**
 * TODO Add JavaDoc description of class
 *
 * @author Jan Lastovicka (lastovicka@avast.com)
 * @since 2015-02-21
 */
final class NettyRequestFactory {

    static HttpRequest getRequest(HttpPostRequest postRequest) {
        ByteBuf payload = Unpooled.copiedBuffer(postRequest.payload());

        FullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, postRequest.uri().getPath(), payload);

        request.headers().add(HttpHeaders.Names.HOST, postRequest.uri().getHost());
        request.headers().add(HttpHeaders.Names.CONTENT_LENGTH, String.valueOf(payload.readableBytes()));
        request.headers().add(HttpHeaders.Names.CONTENT_TYPE, postRequest.contentType());

        return request;
    }
}
