/*
 * Decompiled with CFR 0.152.
 */
package cz.jalasoft.net.http.netty;

import cz.jalasoft.net.http.HttpClient;
import cz.jalasoft.net.http.HttpPostRequest;
import cz.jalasoft.net.http.HttpResponse;
import cz.jalasoft.net.http.netty.NettyChannelInitializer;
import cz.jalasoft.net.http.netty.NettyHttpResponse;
import cz.jalasoft.net.http.netty.NettyHttpResponseCollector;
import cz.jalasoft.net.http.netty.NettyRequestFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;

public final class NettyHttpClient
implements HttpClient {
    private final Bootstrap bootstrap = new Bootstrap();

    public NettyHttpClient() {
        ((Bootstrap)this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class);
    }

    public HttpResponse post(HttpPostRequest request) {
        NettyHttpResponseCollector collector = new NettyHttpResponseCollector();
        this.bootstrap.handler((ChannelHandler)new NettyChannelInitializer((ChannelHandler)collector));
        ChannelFuture channelFuture = this.bootstrap.connect(request.uri().getHost(), request.uri().getPort());
        channelFuture.syncUninterruptibly();
        Channel channel = channelFuture.channel();
        HttpRequest nettyRequest = NettyRequestFactory.getRequest(request);
        channel.writeAndFlush((Object)nettyRequest).syncUninterruptibly();
        channel.closeFuture().syncUninterruptibly();
        FullHttpResponse nettyResponse = collector.getResponse();
        return new NettyHttpResponse(nettyResponse);
    }

    public void close() throws IOException {
        this.bootstrap.group().shutdownGracefully();
    }
}

