/*
 * Decompiled with CFR 0.152.
 */
package cz.jalasoft.net.http.netty;

import cz.jalasoft.net.http.HttpClient;
import cz.jalasoft.net.http.HttpGetRequest;
import cz.jalasoft.net.http.HttpPostRequest;
import cz.jalasoft.net.http.HttpResponse;
import cz.jalasoft.net.http.netty.NettyChannelInitializer;
import cz.jalasoft.net.http.netty.NettyHttpResponse;
import cz.jalasoft.net.http.netty.NettyHttpResponseCollector;
import cz.jalasoft.net.http.netty.NettyRequestFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.net.URI;

public final class NettyHttpClient
implements HttpClient {
    private final Bootstrap bootstrap = new Bootstrap();
    private final NettyHttpResponseCollector responseCollector;

    public NettyHttpClient() {
        ((Bootstrap)this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class);
        this.responseCollector = new NettyHttpResponseCollector();
        this.bootstrap.handler((ChannelHandler)new NettyChannelInitializer((ChannelHandler)this.responseCollector));
    }

    public HttpPostRequest postRequest() {
        return new HttpPostRequest(){

            public HttpResponse send() {
                HttpRequest nettyRequest = NettyRequestFactory.nettyPostRequest(this.uri(), this.payload(), this.headers());
                FullHttpResponse response = NettyHttpClient.this.sendRequest(this.uri(), nettyRequest);
                return new NettyHttpResponse(response);
            }
        };
    }

    public HttpGetRequest getRequest() {
        return new HttpGetRequest(){

            public HttpResponse send() {
                HttpRequest nettyRequest = NettyRequestFactory.nettyGetRequest(this.uri(), this.headers(), this.parameters());
                FullHttpResponse response = NettyHttpClient.this.sendRequest(this.uri(), nettyRequest);
                return new NettyHttpResponse(response);
            }
        };
    }

    private FullHttpResponse sendRequest(URI uri, HttpRequest request) {
        Channel channel = this.establishChannel(uri);
        channel.writeAndFlush((Object)request).syncUninterruptibly();
        channel.closeFuture().syncUninterruptibly();
        return this.responseCollector.getAndRemoveResponse(channel.id());
    }

    private Channel establishChannel(URI uri) {
        ChannelFuture channelFuture = this.bootstrap.connect(uri.getHost(), uri.getPort());
        channelFuture.syncUninterruptibly();
        return channelFuture.channel();
    }

    public void close() throws IOException {
        this.bootstrap.group().shutdownGracefully();
    }
}

