/*
 * Decompiled with CFR 0.152.
 */
package cz.jalasoft.net.http.netty;

import cz.jalasoft.net.http.HttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpResponse;
import java.nio.charset.Charset;

final class NettyHttpResponse
implements HttpResponse {
    private final FullHttpResponse nettyResponse;

    NettyHttpResponse(FullHttpResponse nettyResponse) {
        this.nettyResponse = nettyResponse;
    }

    public boolean isStatusOK() {
        return this.getStatusCode() == 200;
    }

    public int getStatusCode() {
        int code = this.nettyResponse.getStatus().code();
        return code;
    }

    public String getReason() {
        return this.nettyResponse.getStatus().reasonPhrase();
    }

    public byte[] getContent() {
        ByteBuf content = this.nettyResponse.content();
        return content.array();
    }

    public String getContentAsString() {
        return this.nettyResponse.content().toString(Charset.defaultCharset());
    }
}

