/*
 * Decompiled with CFR 0.152.
 */
package cz.jalasoft.net.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

final class NettyRequestFactory {
    NettyRequestFactory() {
    }

    static HttpRequest nettyPostRequest(URI uri, byte[] payloadBytes, Map<String, String> headers) {
        ByteBuf payload = Unpooled.copiedBuffer((byte[])payloadBytes);
        HashMap<String, String> finalHeaders = new HashMap<String, String>(headers);
        finalHeaders.put("Host", uri.getHost());
        finalHeaders.put("Content-Length", String.valueOf(payload.readableBytes()));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri.getPath(), payload);
        for (String key : finalHeaders.keySet()) {
            String value = (String)finalHeaders.get(key);
            request.headers().add((CharSequence)key, (Object)value);
        }
        return request;
    }

    static HttpRequest nettyGetRequest(URI uri, Map<String, String> headers, Map<String, String> parameters) {
        HashMap<String, String> finalHeaders = new HashMap<String, String>(headers);
        finalHeaders.put("Host", uri.getHost());
        String queryString = NettyRequestFactory.constructQueryString(parameters);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getPath() + queryString);
        for (String key : finalHeaders.keySet()) {
            String value = (String)finalHeaders.get(key);
            request.headers().add((CharSequence)key, (Object)value);
        }
        return request;
    }

    private static String constructQueryString(Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return "";
        }
        StringBuilder bldr = new StringBuilder("?");
        int count = 0;
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            String pair = key + "=" + value;
            bldr.append(pair);
            if (count < parameters.size() - 1) {
                bldr.append("&");
            }
            ++count;
        }
        return bldr.toString();
    }
}

