/*
 * Decompiled with CFR 0.152.
 */
package g1701_1800.s1786_number_of_restricted_paths_from_first_to_last_node;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public class Solution {
    private int[] dtl;
    private int[] dp;
    private static final int M = 1000000007;

    public int countRestrictedPaths(int n, int[][] edges) {
        List<List<Edge>> graph = this.buildGraph(n, edges);
        PriorityQueue<Pair> pq = new PriorityQueue<Pair>();
        boolean[] vis = new boolean[n + 1];
        this.dtl = new int[n + 1];
        pq.add(new Pair(n, 0));
        while (!pq.isEmpty()) {
            Pair rem = (Pair)pq.remove();
            if (vis[rem.v]) continue;
            this.dtl[rem.v] = rem.cwt;
            vis[rem.v] = true;
            for (Edge edge : graph.get(rem.v)) {
                if (vis[edge.v]) continue;
                pq.add(new Pair(edge.v, rem.cwt + edge.wt));
            }
        }
        this.dp = new int[n + 1];
        return this.dfs(graph, 1, new boolean[n + 1], n);
    }

    private int dfs(List<List<Edge>> graph, int vtx, boolean[] vis, int n) {
        if (vtx == n) {
            return 1;
        }
        long ans = 0L;
        vis[vtx] = true;
        for (Edge edge : graph.get(vtx)) {
            if (!vis[edge.v] && this.dtl[edge.v] < this.dtl[vtx]) {
                int x = this.dfs(graph, edge.v, vis, n);
                ans = (ans + (long)x) % 1000000007L;
                continue;
            }
            if (this.dtl[edge.v] >= this.dtl[vtx] || !vis[edge.v]) continue;
            ans = (ans + (long)this.dp[edge.v]) % 1000000007L;
        }
        this.dp[vtx] = (int)ans;
        return (int)ans;
    }

    private List<List<Edge>> buildGraph(int n, int[][] edges) {
        ArrayList<List<Edge>> graph = new ArrayList<List<Edge>>();
        for (int i = 0; i <= n; ++i) {
            graph.add(new ArrayList());
        }
        for (int[] edge : edges) {
            int u = edge[0];
            int v = edge[1];
            int wt = edge[2];
            ((List)graph.get(u)).add(new Edge(v, wt));
            ((List)graph.get(v)).add(new Edge(u, wt));
        }
        return graph;
    }

    private static class Edge {
        int v;
        int wt;

        Edge(int v, int wt) {
            this.v = v;
            this.wt = wt;
        }
    }

    private static class Pair
    implements Comparable<Pair> {
        int v;
        int cwt;

        Pair(int v, int cwt) {
            this.v = v;
            this.cwt = cwt;
        }

        @Override
        public int compareTo(Pair o) {
            return this.cwt - o.cwt;
        }
    }
}

