/*
 * Decompiled with CFR 0.152.
 */
package g1701_1800.s1722_minimize_hamming_distance_after_swap_operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Solution {
    public int minimumHammingDistance(int[] source, int[] target, int[][] allowedSwaps) {
        int i;
        int n = source.length;
        int weight = 0;
        int[] parent = new int[n];
        for (i = 0; i < n; ++i) {
            parent[i] = i;
        }
        for (int[] swap : allowedSwaps) {
            this.union(swap[0], swap[1], parent);
        }
        HashMap<Integer, List> components = new HashMap<Integer, List>();
        for (i = 0; i < n; ++i) {
            this.find(i, parent);
            List list = components.getOrDefault(parent[i], new ArrayList());
            list.add(i);
            components.put(parent[i], list);
        }
        for (Map.Entry entry : components.entrySet()) {
            weight += this.getHammingDistance(source, target, (List)entry.getValue());
        }
        return weight;
    }

    private int getHammingDistance(int[] source, int[] target, List<Integer> indices) {
        HashMap<Integer, Integer> list1 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> list2 = new HashMap<Integer, Integer>();
        for (int i : indices) {
            list1.put(target[i], 1 + list1.getOrDefault(target[i], 0));
            list2.put(source[i], 1 + list2.getOrDefault(source[i], 0));
        }
        int size = indices.size();
        for (Map.Entry entry : list1.entrySet()) {
            size -= Math.min((Integer)entry.getValue(), list2.getOrDefault(entry.getKey(), 0));
        }
        return size;
    }

    private void union(int x, int y, int[] parent) {
        int b;
        int a;
        if (x != y && (a = this.find(x, parent)) != (b = this.find(y, parent))) {
            parent[a] = b;
        }
    }

    private int find(int x, int[] parent) {
        int y = x;
        while (y != parent[y]) {
            y = parent[y];
        }
        parent[x] = y;
        return y;
    }
}

