/*
 * Decompiled with CFR 0.152.
 */
package g0201_0300.s0211_design_add_and_search_words_data_structure;

public class WordDictionary {
    private final Node[] root = new Node[26];

    public void addWord(String word) {
        int n = word.length();
        if (this.root[n] == null) {
            this.root[n] = new Node();
        }
        Node node = this.root[n];
        for (int i = 0; i < n; ++i) {
            int c = word.charAt(i) - 97;
            Node kid = node.kids[c];
            if (kid == null) {
                node.kids[c] = kid = new Node();
            }
            node = kid;
        }
        node.isTerminal = true;
    }

    public boolean search(String word) {
        Node node = this.root[word.length()];
        return node != null && this.dfs(0, node, word);
    }

    private boolean dfs(int i, Node node, String word) {
        int len = word.length();
        if (i == len) {
            return false;
        }
        char c = word.charAt(i);
        if (c == '.') {
            for (Node kid : node.kids) {
                if (kid == null || (i != len - 1 || !kid.isTerminal) && !this.dfs(i + 1, kid, word)) continue;
                return true;
            }
            return false;
        }
        Node kid = node.kids[c - 97];
        if (kid == null) {
            return false;
        }
        if (i == len - 1) {
            return kid.isTerminal;
        }
        return this.dfs(i + 1, kid, word);
    }

    private static class Node {
        Node[] kids = new Node[26];
        boolean isTerminal;

        private Node() {
        }
    }
}

