/*
 * Decompiled with CFR 0.152.
 */
package g1801_1900.s1825_finding_mk_average;

import java.util.LinkedList;
import java.util.TreeSet;

public class MKAverage {
    private final int capacity;
    private final int boundary;
    private final int[] nums;
    private final TreeSet<Integer> numSet;
    private final LinkedList<Integer> order;

    public MKAverage(int m, int k) {
        this.capacity = m;
        this.boundary = k;
        this.nums = new int[100001];
        this.numSet = new TreeSet();
        this.order = new LinkedList();
    }

    public void addElement(int num) {
        if (this.order.size() == this.capacity) {
            int numToDelete = this.order.removeFirst();
            this.nums[numToDelete] = this.nums[numToDelete] - 1;
            if (this.nums[numToDelete] == 0) {
                this.numSet.remove(numToDelete);
            }
        }
        int n = num;
        this.nums[n] = this.nums[n] + 1;
        this.numSet.add(num);
        this.order.add(num);
    }

    public int calculateMKAverage() {
        if (this.order.size() == this.capacity) {
            int skipCount = this.boundary;
            int numsCount = this.capacity - 2 * this.boundary;
            int freq = this.capacity - 2 * this.boundary;
            int sum = 0;
            for (int num : this.numSet) {
                int count = this.nums[num];
                if (skipCount < 0) {
                    sum += num * Math.min(count, numsCount);
                    numsCount -= Math.min(count, numsCount);
                } else if ((skipCount -= count) < 0) {
                    sum += num * Math.min(Math.abs(skipCount), numsCount);
                    numsCount -= Math.min(Math.abs(skipCount), numsCount);
                }
                if (numsCount != 0) continue;
                break;
            }
            return sum / freq;
        }
        return -1;
    }
}

