/*
 * Decompiled with CFR 0.152.
 */
package g1901_2000.s1948_delete_duplicate_folders_in_system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Solution {
    private Map<String, ArrayList<Folder>> duplicates;
    private List<List<String>> foldersWithRemovedNames;

    public List<List<String>> deleteDuplicateFolder(List<List<String>> paths) {
        Folder folder;
        this.duplicates = new HashMap<String, ArrayList<Folder>>();
        Folder rootFolder = new Folder("", null);
        for (List<String> list : paths) {
            folder = rootFolder;
            for (String foldername : list) {
                folder = folder.addSubFolder(foldername);
            }
        }
        rootFolder.calculateHash();
        for (Map.Entry entry : this.duplicates.entrySet()) {
            ArrayList foldersWithSameHash = (ArrayList)entry.getValue();
            if (foldersWithSameHash == null || foldersWithSameHash.size() <= 1) continue;
            for (Folder folder2 : foldersWithSameHash) {
                folder2.parent.subFolders.remove(folder2.name);
            }
        }
        this.foldersWithRemovedNames = new ArrayList<List<String>>();
        for (Map.Entry entry : rootFolder.subFolders.entrySet()) {
            folder = (Folder)entry.getValue();
            ArrayList<String> path = new ArrayList<String>();
            folder.addPaths(path);
        }
        return this.foldersWithRemovedNames;
    }

    private class Folder {
        private String name;
        private Map<String, Folder> subFolders;
        private Folder parent;
        private String folderHash;

        private Folder(String folderName, Folder parentFolder) {
            this.name = folderName;
            this.subFolders = new HashMap<String, Folder>();
            this.folderHash = "";
            this.parent = parentFolder;
        }

        private Folder addSubFolder(String foldername) {
            return this.subFolders.computeIfAbsent(foldername, f -> new Folder((String)f, this));
        }

        private void calculateHash() {
            ArrayList<String> subFolderNames = new ArrayList<String>(this.subFolders.keySet());
            Collections.sort(subFolderNames);
            StringBuilder builder = new StringBuilder();
            for (String foldername : subFolderNames) {
                Folder folder = this.subFolders.get(foldername);
                folder.calculateHash();
                builder.append('#');
                builder.append(foldername);
                if (folder.folderHash.isEmpty()) continue;
                builder.append('(');
                builder.append(folder.folderHash);
                builder.append(')');
            }
            this.folderHash = builder.toString();
            if (!this.folderHash.isEmpty()) {
                ArrayList duplicateFolders = Solution.this.duplicates.computeIfAbsent(this.folderHash, k -> new ArrayList());
                duplicateFolders.add(this);
            }
        }

        private void addPaths(List<String> parentPath) {
            ArrayList<String> currentPath = new ArrayList<String>(parentPath);
            currentPath.add(this.name);
            Solution.this.foldersWithRemovedNames.add(currentPath);
            for (Map.Entry<String, Folder> entry : this.subFolders.entrySet()) {
                Folder folder = entry.getValue();
                folder.addPaths(currentPath);
            }
        }
    }
}

