/*
 * Decompiled with CFR 0.152.
 */
package g2101_2200.s2166_design_bitset;

import java.util.Arrays;

public class Bitset {
    private boolean[] bits;
    private boolean[] flipped;
    private int sz;
    private int cnt;

    public Bitset(int size) {
        this.sz = size;
        this.bits = new boolean[size];
        this.flipped = new boolean[size];
        Arrays.fill(this.flipped, true);
    }

    public void fix(int idx) {
        if (!this.bits[idx]) {
            int n = idx;
            this.bits[n] = this.bits[n] ^ true;
            int n2 = idx;
            this.flipped[n2] = this.flipped[n2] ^ true;
            ++this.cnt;
        }
    }

    public void unfix(int idx) {
        if (this.bits[idx]) {
            int n = idx;
            this.bits[n] = this.bits[n] ^ true;
            int n2 = idx;
            this.flipped[n2] = this.flipped[n2] ^ true;
            --this.cnt;
        }
    }

    public void flip() {
        boolean[] tmp = this.bits;
        this.bits = this.flipped;
        this.flipped = tmp;
        this.cnt = this.sz - this.cnt;
    }

    public boolean all() {
        return this.cnt == this.sz;
    }

    public boolean one() {
        return this.cnt > 0;
    }

    public int count() {
        return this.cnt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (boolean b : this.bits) {
            sb.append(b ? (char)'1' : '0');
        }
        return sb.toString();
    }
}

