/*
 * Decompiled with CFR 0.152.
 */
package g2201_2300.s2213_longest_substring_of_one_repeating_character;

public class Solution {
    private char[] ca;

    public int[] longestRepeating(String s, String queryCharacters, int[] queryIndices) {
        this.ca = s.toCharArray();
        int[] result = new int[queryIndices.length];
        SegmentTree root = new SegmentTree(0, this.ca.length);
        for (int i = 0; i < queryIndices.length; ++i) {
            this.ca[queryIndices[i]] = queryCharacters.charAt(i);
            root.update(queryIndices[i]);
            result[i] = root.longest;
        }
        return result;
    }

    private class SegmentTree {
        final int start;
        final int end;
        int longest;
        int leftLength;
        int rightLength;
        SegmentTree left;
        SegmentTree right;

        SegmentTree(int start, int end) {
            this.start = start;
            this.end = end;
            if (end - start > 1) {
                int mid = (start + end) / 2;
                this.left = new SegmentTree(start, mid);
                this.right = new SegmentTree(mid, end);
                this.merge();
            } else {
                this.rightLength = 1;
                this.leftLength = 1;
                this.longest = 1;
            }
        }

        void update(int index) {
            if (this.end - this.start == 1) {
                return;
            }
            if (index < this.left.end) {
                this.left.update(index);
            } else {
                this.right.update(index);
            }
            this.merge();
        }

        private void merge() {
            this.longest = Math.max(this.left.longest, this.right.longest);
            if (Solution.this.ca[this.left.end - 1] == Solution.this.ca[this.right.start]) {
                this.longest = Math.max(this.longest, this.left.rightLength + this.right.leftLength);
                this.leftLength = this.left.leftLength == this.left.end - this.left.start ? this.left.leftLength + this.right.leftLength : this.left.leftLength;
                this.rightLength = this.right.rightLength == this.right.end - this.right.start ? this.right.rightLength + this.left.rightLength : this.right.rightLength;
            } else {
                this.leftLength = this.left.leftLength;
                this.rightLength = this.right.rightLength;
            }
        }
    }
}

