/*
 * Decompiled with CFR 0.152.
 */
package g2401_2500.s2407_longest_increasing_subsequence_ii;

public class Solution {
    public int lengthOfLIS(int[] nums, int k) {
        int max = 0;
        for (int n : nums) {
            max = Math.max(max, n);
        }
        SegTree seg = new SegTree(max);
        int ans = 0;
        for (int n : nums) {
            int temp = seg.query(Math.max(0, --n - k), n) + 1;
            ans = Math.max(ans, temp);
            seg.update(n, temp);
        }
        return ans;
    }

    private static class SegTree {
        private int[] arr;
        private int n;

        public SegTree(int n) {
            this.n = n;
            this.arr = new int[2 * n];
        }

        public int query(int l, int r) {
            l += this.n;
            r += this.n;
            int ans = 0;
            while (l < r) {
                if ((l & 1) == 1) {
                    ans = Math.max(ans, this.arr[l]);
                    ++l;
                }
                if ((r & 1) == 1) {
                    ans = Math.max(ans, this.arr[--r]);
                }
                l >>= 1;
                r >>= 1;
            }
            return ans;
        }

        public void update(int i, int val) {
            this.arr[i += this.n] = val;
            while (i > 0) {
                this.arr[i >>= 1] = Math.max(this.arr[2 * i], this.arr[2 * i + 1]);
            }
        }
    }
}

