/*
 * Decompiled with CFR 0.152.
 */
package g2801_2900.s2818_apply_operations_to_maximize_score;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;

public class Solution {
    private static final int N = 100000;
    private static final int[] PRIME_SCORES = Solution.computePrimeScores();
    private static final int MOD = 1000000007;

    public int maximumScore(List<Integer> nums, int k) {
        int[] dp = new int[nums.size()];
        PriorityQueue<int[]> pq = new PriorityQueue<int[]>((o1, o2) -> Integer.compare(o2[0], o1[0]));
        ArrayDeque<int[]> monoStack = new ArrayDeque<int[]>();
        Arrays.fill(dp, 1);
        for (int i = 0; i <= nums.size(); ++i) {
            int score = Integer.MAX_VALUE;
            if (i < nums.size()) {
                score = PRIME_SCORES[nums.get(i)];
            }
            while (!monoStack.isEmpty() && ((int[])monoStack.peekFirst())[0] < score) {
                int popIndex = ((int[])monoStack.pollFirst())[1];
                int actualRightIndexOfPopedElement = i - 1;
                int n = popIndex;
                dp[n] = dp[n] * (actualRightIndexOfPopedElement - popIndex + 1);
            }
            if (i >= nums.size()) continue;
            int peekIndex = monoStack.isEmpty() ? -1 : ((int[])monoStack.peekFirst())[1];
            int actualLeftIndexOfCurrentElement = peekIndex + 1;
            int n = i;
            dp[n] = dp[n] * (i - actualLeftIndexOfCurrentElement + 1);
            monoStack.offerFirst(new int[]{score, i});
            pq.offer(new int[]{nums.get(i), i});
        }
        long result = 1L;
        while (k > 0) {
            int[] pair = (int[])pq.poll();
            int val = pair[0];
            int index = pair[1];
            int times = Math.min(k, dp[index]);
            long power = this.pow(val, times);
            result *= power;
            result %= 1000000007L;
            k -= times;
        }
        return (int)result;
    }

    private static int[] computePrimeScores() {
        int[] primeCnt = new int[100001];
        for (int i = 2; i <= 100000; ++i) {
            if (primeCnt[i] != 0) continue;
            for (int j = i; j <= 100000; j += i) {
                int n = j;
                primeCnt[n] = primeCnt[n] + 1;
            }
        }
        return primeCnt;
    }

    private long pow(long val, int times) {
        if (times == 1) {
            return val % 1000000007L;
        }
        long subProblemRes = this.pow(val, times / 2);
        long third = 1L;
        if (times % 2 == 1) {
            third = val;
        }
        return subProblemRes * subProblemRes % 1000000007L * third % 1000000007L;
    }
}

