/*
 * Decompiled with CFR 0.152.
 */
package g2901_3000.s2910_minimum_number_of_groups_to_create_a_valid_assignment;

import java.util.HashMap;
import java.util.Map;

public class Solution {
    public int minGroupsForValidAssignment(int[] nums) {
        int minFrequency;
        Map<Integer, Integer> count = this.getCountMap(nums);
        Map<Integer, Integer> countFreq = this.getCountFrequencyMap(count);
        for (int size = minFrequency = this.getMinFrequency(countFreq); size >= 1; --size) {
            int group = this.calculateGroups(countFreq, size);
            if (group <= 0) continue;
            return group;
        }
        return -1;
    }

    private Map<Integer, Integer> getCountMap(int[] nums) {
        HashMap<Integer, Integer> count = new HashMap<Integer, Integer>();
        for (int num : nums) {
            count.merge(num, 1, Integer::sum);
        }
        return count;
    }

    private Map<Integer, Integer> getCountFrequencyMap(Map<Integer, Integer> count) {
        HashMap<Integer, Integer> countFreq = new HashMap<Integer, Integer>();
        for (int c : count.values()) {
            countFreq.merge(c, 1, Integer::sum);
        }
        return countFreq;
    }

    private int getMinFrequency(Map<Integer, Integer> countFreq) {
        return (Integer)countFreq.keySet().stream().min(Integer::compareTo).orElseThrow(() -> new IllegalStateException("Count frequency map is empty"));
    }

    private int calculateGroups(Map<Integer, Integer> countFreq, int size) {
        int group = 0;
        for (Map.Entry<Integer, Integer> entry : countFreq.entrySet()) {
            int len = entry.getKey();
            int rem = len % (size + 1);
            int g = len / (size + 1);
            if (rem == 0) {
                group += g * entry.getValue();
                continue;
            }
            int need = size - rem;
            if (g >= need) {
                group += (g + 1) * entry.getValue();
                continue;
            }
            return -1;
        }
        return group;
    }
}

