/*
 * Decompiled with CFR 0.152.
 */
package g3001_3100.s3076_shortest_uncommon_substring_in_an_array;

public class Solution {
    private final Trie root = new Trie();

    public String[] shortestSubstrings(String[] arr) {
        int n = arr.length;
        for (int k = 0; k < n; ++k) {
            String s = arr[k];
            char[] cs = s.toCharArray();
            int m = cs.length;
            for (int i = 0; i < m; ++i) {
                this.insert(cs, i, m, k);
            }
        }
        String[] ans = new String[n];
        for (int k = 0; k < n; ++k) {
            String s = arr[k];
            char[] cs = s.toCharArray();
            int m = cs.length;
            String result = "";
            int resultLen = m + 1;
            for (int i = 0; i < m; ++i) {
                int curLen = this.search(cs, i, Math.min(m, i + resultLen), k);
                if (curLen == -1) continue;
                String sub = new String(cs, i, curLen);
                if (curLen >= resultLen && result.compareTo(sub) <= 0) continue;
                result = sub;
                resultLen = curLen;
            }
            ans[k] = result;
        }
        return ans;
    }

    private void insert(char[] cs, int start, int end, int wordIndex) {
        Trie curr = this.root;
        for (int i = start; i < end; ++i) {
            int index = cs[i] - 97;
            if (curr.children[index] == null) {
                curr.children[index] = new Trie();
            }
            curr = curr.children[index];
            curr.wordIndex = curr.wordIndex == -1 || curr.wordIndex == wordIndex ? wordIndex : -2;
        }
    }

    private int search(char[] cs, int start, int end, int wordIndex) {
        Trie cur = this.root;
        for (int i = start; i < end; ++i) {
            int index = cs[i] - 97;
            cur = cur.children[index];
            if (cur.wordIndex != wordIndex) continue;
            return i - start + 1;
        }
        return -1;
    }

    private static class Trie {
        Trie[] children = new Trie[26];
        int wordIndex = -1;
    }
}

