/*
 * Decompiled with CFR 0.152.
 */
package g3201_3300.s3213_construct_string_with_minimum_cost;

import java.util.Arrays;

public class Solution {
    public int minimumCost(String target, String[] words, int[] costs) {
        ACAutomaton ac = new ACAutomaton();
        ACAutomaton.Node root = ac.build(words, costs);
        int[] dp = new int[target.length() + 1];
        Arrays.fill(dp, 0x3FFFFFFF);
        dp[0] = 0;
        ACAutomaton.Node node = root;
        for (int i = 1; i < dp.length; ++i) {
            if (node != null) {
                node = ac.go(node, target.charAt(i - 1));
            }
            ACAutomaton.Node temp = node;
            while (temp != null && temp != root) {
                if (temp.val != null && dp[i - temp.len] < 0x3FFFFFFF) {
                    dp[i] = Math.min(dp[i], dp[i - temp.len] + temp.val);
                }
                temp = ac.getOutput(temp);
            }
        }
        return dp[dp.length - 1] >= 0x3FFFFFFF ? -1 : dp[dp.length - 1];
    }

    private static class ACAutomaton {
        private ACAutomaton() {
        }

        public Node build(String[] patterns, int[] values) {
            int i;
            Node root;
            root.suffix = root = new Node();
            root.output = root;
            for (i = 0; i < patterns.length; ++i) {
                this.put(root, patterns[i], values[i]);
            }
            for (i = 0; i < root.next.length; ++i) {
                if (root.next[i] == null) {
                    root.next[i] = root;
                    continue;
                }
                root.next[i].suffix = root;
            }
            return root;
        }

        private void put(Node root, String s, int val) {
            Node node = root;
            for (char c : s.toCharArray()) {
                if (node.next[c - 97] == null) {
                    node.next[c - 97] = new Node();
                    node.next[c - 97].parent = node;
                    node.next[c - 97].key = c;
                }
                node = node.next[c - 97];
            }
            if (node.val == null || node.val > val) {
                node.val = val;
                node.len = s.length();
            }
        }

        public Node getOutput(Node node) {
            if (node.output == null) {
                Node suffix = this.getSuffix(node);
                node.output = suffix.val != null ? suffix : this.getOutput(suffix);
            }
            return node.output;
        }

        private Node go(Node node, char c) {
            if (node.next[c - 97] == null) {
                node.next[c - 97] = this.go(this.getSuffix(node), c);
            }
            return node.next[c - 97];
        }

        private Node getSuffix(Node node) {
            if (node.suffix == null) {
                node.suffix = this.go(this.getSuffix(node.parent), node.key);
                node.output = node.suffix.val != null ? node.suffix : node.suffix.output;
            }
            return node.suffix;
        }

        private static class Node {
            private char key;
            private Integer val = null;
            private int len;
            private final Node[] next = new Node[26];
            private Node suffix = null;
            private Node output = null;
            private Node parent = null;

            private Node() {
            }
        }
    }
}

