/*
 * Decompiled with CFR 0.152.
 */
package g3201_3300.s3245_alternating_groups_iii;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class Solution {
    public List<Integer> numberOfAlternatingGroups(int[] colors, int[][] queries) {
        int n = colors.length;
        BitSet set = new BitSet();
        BIT bit = new BIT(n);
        for (int i = 0; i < n; ++i) {
            if (colors[i] != colors[this.getIndex(i + 1, n)]) continue;
            this.add(set, bit, n, i);
        }
        ArrayList<Integer> ans = new ArrayList<Integer>();
        for (int[] q : queries) {
            int next;
            if (q[0] == 1) {
                if (set.isEmpty()) {
                    ans.add(n);
                    continue;
                }
                int size = q[1];
                int[] res = bit.query(size);
                ans.add(res[1] - res[0] * (size - 1));
                continue;
            }
            int i = q[1];
            int color = colors[i];
            if (q[2] == color) continue;
            int pre = this.getIndex(i - 1, n);
            if (colors[pre] == color) {
                this.remove(set, bit, n, pre);
            }
            if (colors[next = this.getIndex(i + 1, n)] == color) {
                this.remove(set, bit, n, i);
            }
            int n2 = i;
            colors[n2] = colors[n2] ^ 1;
            color = colors[i];
            if (colors[pre] == color) {
                this.add(set, bit, n, pre);
            }
            if (colors[next] != color) continue;
            this.add(set, bit, n, i);
        }
        return ans;
    }

    private void add(BitSet set, BIT bit, int n, int i) {
        if (set.isEmpty()) {
            bit.update(n, 1);
        } else {
            this.update(set, bit, n, i, 1);
        }
        set.set(i);
    }

    private void remove(BitSet set, BIT bit, int n, int i) {
        set.clear(i);
        if (set.isEmpty()) {
            bit.update(n, -1);
        } else {
            this.update(set, bit, n, i, -1);
        }
    }

    private void update(BitSet set, BIT bit, int n, int i, int v) {
        int next;
        int pre = set.previousSetBit(i);
        if (pre == -1) {
            pre = set.previousSetBit(n);
        }
        if ((next = set.nextSetBit(i)) == -1) {
            next = set.nextSetBit(0);
        }
        bit.update(this.getIndex(next - pre + n - 1, n) + 1, -v);
        bit.update(this.getIndex(i - pre, n), v);
        bit.update(this.getIndex(next - i, n), v);
    }

    private int getIndex(int index, int mod) {
        int result = index >= mod ? index - mod : index;
        return index < 0 ? index + mod : result;
    }

    private static class BIT {
        int n;
        int[] tree1;
        int[] tree2;

        BIT(int n) {
            this.n = n + 1;
            this.tree1 = new int[n + 1];
            this.tree2 = new int[n + 1];
        }

        void update(int size, int v) {
            for (int i = size; i > 0; i -= i & -i) {
                int n = i;
                this.tree1[n] = this.tree1[n] + v;
                int n2 = i;
                this.tree2[n2] = this.tree2[n2] + v * size;
            }
        }

        int[] query(int size) {
            int count = 0;
            int sum = 0;
            for (int i = size; i < this.n; i += i & -i) {
                count += this.tree1[i];
                sum += this.tree2[i];
            }
            return new int[]{count, sum};
        }
    }
}

