/*
 * Decompiled with CFR 0.152.
 */
package g3301_3400.s3378_count_connected_components_in_lcm_graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Solution {
    public int countComponents(int[] nums, int threshold) {
        ArrayList<Integer> goodNums = new ArrayList<Integer>();
        int totalNums = nums.length;
        for (int num : nums) {
            if (num > threshold) continue;
            goodNums.add(num);
        }
        if (goodNums.isEmpty()) {
            return totalNums;
        }
        Unionfind uf = new Unionfind(goodNums.size());
        int[] presentElements = new int[threshold + 1];
        Arrays.fill(presentElements, -1);
        for (int i = 0; i < goodNums.size(); ++i) {
            presentElements[((Integer)goodNums.get((int)i)).intValue()] = i;
        }
        Iterator iterator = goodNums.iterator();
        while (iterator.hasNext()) {
            int d;
            for (int i = d = ((Integer)iterator.next()).intValue(); i <= threshold; i += d) {
                if (presentElements[i] == -1) {
                    presentElements[i] = presentElements[d];
                    continue;
                }
                if (presentElements[i] == presentElements[d]) continue;
                uf.union(presentElements[i], presentElements[d]);
            }
        }
        return uf.totalComponents + totalNums - goodNums.size();
    }

    private static class Unionfind {
        int[] parent;
        int[] rank;
        int totalComponents;

        public Unionfind(int n) {
            this.parent = new int[n];
            this.rank = new int[n];
            this.totalComponents = n;
            for (int i = 0; i < n; ++i) {
                this.parent[i] = i;
            }
        }

        public int find(int u) {
            if (this.parent[u] == u) {
                return u;
            }
            this.parent[u] = this.find(this.parent[u]);
            return this.parent[u];
        }

        public void union(int u, int v) {
            int parentV;
            int parentU = this.find(u);
            if (parentU != (parentV = this.find(v))) {
                --this.totalComponents;
                if (this.rank[parentU] == this.rank[parentV]) {
                    this.parent[parentV] = parentU;
                    int n = parentU;
                    this.rank[n] = this.rank[n] + 1;
                } else if (this.rank[parentU] > this.rank[parentV]) {
                    this.parent[parentV] = parentU;
                } else {
                    this.parent[parentU] = parentV;
                }
            }
        }
    }
}

