/*
 * Decompiled with CFR 0.152.
 */
package g3401_3500.s3454_separate_squares_ii;

import java.util.ArrayList;
import java.util.Arrays;

public class Solution {
    public double separateSquares(int[][] squares) {
        int n = squares.length;
        Object[] events = new Event[2 * n];
        int idx = 0;
        ArrayList<Integer> xList = new ArrayList<Integer>();
        for (int[] s : squares) {
            int x = s[0];
            int y = s[1];
            int l = s[2];
            int x2 = x + l;
            int y2 = y + l;
            events[idx++] = new Event(y, x, x2, 1);
            events[idx++] = new Event(y2, x, x2, -1);
            xList.add(x);
            xList.add(x2);
        }
        Arrays.sort(events);
        int m = xList.size();
        int[] xCords = new int[m];
        for (int i = 0; i < m; ++i) {
            xCords[i] = (Integer)xList.get(i);
        }
        Arrays.sort(xCords);
        int uniqueCount = 0;
        for (int i = 0; i < m; ++i) {
            if (i != 0 && xCords[i] == xCords[i - 1]) continue;
            xCords[uniqueCount++] = xCords[i];
        }
        int[] x = Arrays.copyOf(xCords, uniqueCount);
        SegmentTree segTree = new SegmentTree(x);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        double cumArea = 0.0;
        double lastY = ((Event)events[0]).y;
        int iEvent = 0;
        while (iEvent < events.length) {
            double currentY = ((Event)events[iEvent]).y;
            double delta = currentY - lastY;
            if (delta > 0.0) {
                double unionX = segTree.query();
                segments.add(new Segment(lastY, currentY, unionX, cumArea));
                cumArea += unionX * delta;
            }
            while (iEvent < events.length && ((Event)events[iEvent]).y == currentY) {
                int right;
                Object e = events[iEvent];
                int left = Arrays.binarySearch(x, ((Event)e).x1);
                if (left < (right = Arrays.binarySearch(x, ((Event)e).x2))) {
                    segTree.update(left, right - 1, ((Event)e).type);
                }
                ++iEvent;
            }
            lastY = currentY;
        }
        double totalArea = cumArea;
        double target = totalArea / 2.0;
        for (Segment seg : segments) {
            double segArea = seg.unionX * (seg.y2 - seg.y1);
            if (!(seg.cumArea + segArea >= target)) continue;
            double needed = target - seg.cumArea;
            double answer = seg.y1 + needed / seg.unionX;
            return answer;
        }
        return lastY;
    }

    private static class Event
    implements Comparable<Event> {
        double y;
        int x1;
        int x2;
        int type;

        Event(double y, int x1, int x2, int type) {
            this.y = y;
            this.x1 = x1;
            this.x2 = x2;
            this.type = type;
        }

        @Override
        public int compareTo(Event other) {
            return Double.compare(this.y, other.y);
        }
    }

    private static class SegmentTree {
        int[] count;
        double[] len;
        int n;
        int[] x;

        SegmentTree(int[] x) {
            this.x = x;
            this.n = x.length - 1;
            this.count = new int[4 * this.n];
            this.len = new double[4 * this.n];
        }

        void update(int idx, int l, int r, int ql, int qr, int val) {
            if (qr < l || ql > r) {
                return;
            }
            if (ql <= l && r <= qr) {
                int n = idx;
                this.count[n] = this.count[n] + val;
            } else {
                int mid = (l + r) / 2;
                this.update(2 * idx + 1, l, mid, ql, qr, val);
                this.update(2 * idx + 2, mid + 1, r, ql, qr, val);
            }
            this.len[idx] = this.count[idx] > 0 ? (double)this.x[r + 1] - (double)this.x[l] : (l == r ? 0.0 : this.len[2 * idx + 1] + this.len[2 * idx + 2]);
        }

        void update(int ql, int qr, int val) {
            this.update(0, 0, this.n - 1, ql, qr, val);
        }

        double query() {
            return this.len[0];
        }
    }

    private static class Segment {
        double y1;
        double y2;
        double unionX;
        double cumArea;

        Segment(double y1, double y2, double unionX, double cumArea) {
            this.y1 = y1;
            this.y2 = y2;
            this.unionX = unionX;
            this.cumArea = cumArea;
        }
    }
}

