/*
 * Decompiled with CFR 0.152.
 */
package g3401_3500.s3485_longest_common_prefix_of_k_strings_after_removal;

public class Solution {
    private TrieNode root;

    public int[] longestCommonPrefix(String[] words, int k) {
        int totalWords = words.length;
        int[] result = new int[totalWords];
        if (totalWords - 1 < k) {
            return result;
        }
        this.root = new TrieNode();
        for (String word : words) {
            this.updateTrie(word, 1, k);
        }
        for (int i = 0; i < totalWords; ++i) {
            this.updateTrie(words[i], -1, k);
            result[i] = this.root.bestPrefixLength;
            this.updateTrie(words[i], 1, k);
        }
        return result;
    }

    private void updateTrie(String word, int count, int k) {
        int wordLength = word.length();
        TrieNode[] nodePath = new TrieNode[wordLength + 1];
        int[] depths = new int[wordLength + 1];
        nodePath[0] = this.root;
        depths[0] = 0;
        for (int i = 0; i < wordLength; ++i) {
            int letterIndex = word.charAt(i) - 97;
            if (nodePath[i].children[letterIndex] == null) {
                nodePath[i].children[letterIndex] = new TrieNode();
            }
            nodePath[i + 1] = nodePath[i].children[letterIndex];
            depths[i + 1] = depths[i] + 1;
        }
        for (TrieNode node : nodePath) {
            node.count += count;
        }
        for (int i = nodePath.length - 1; i >= 0; --i) {
            TrieNode currentNode = nodePath[i];
            int candidate = currentNode.count >= k ? depths[i] : -1;
            for (TrieNode childNode : currentNode.children) {
                if (childNode == null) continue;
                candidate = Math.max(candidate, childNode.bestPrefixLength);
            }
            currentNode.bestPrefixLength = candidate;
        }
    }

    private static class TrieNode {
        TrieNode[] children = new TrieNode[26];
        int count = 0;
        int bestPrefixLength = -1;

        private TrieNode() {
        }
    }
}

