/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3508_implement_router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;

public class Router {
    private final int size;
    private int cur;
    private final Queue<int[]> q = new LinkedList<int[]>();
    private final HashMap<Integer, ArrayList<int[]>> map = new HashMap();

    public Router(int memoryLimit) {
        this.size = memoryLimit;
        this.cur = 0;
    }

    public boolean addPacket(int source, int destination, int timestamp) {
        if (this.map.containsKey(destination)) {
            boolean found = false;
            ArrayList<int[]> list = this.map.get(destination);
            for (int i = list.size() - 1; i >= 0 && list.get(i)[1] >= timestamp; --i) {
                if (list.get(i)[0] != source) continue;
                found = true;
                break;
            }
            if (found) {
                return false;
            }
        }
        if (this.map.containsKey(destination)) {
            ArrayList<int[]> list = this.map.get(destination);
            list.add(new int[]{source, timestamp});
            ++this.cur;
            this.q.offer(new int[]{source, destination, timestamp});
        } else {
            ArrayList<int[]> temp = new ArrayList<int[]>();
            temp.add(new int[]{source, timestamp});
            ++this.cur;
            this.map.put(destination, temp);
            this.q.offer(new int[]{source, destination, timestamp});
        }
        if (this.cur > this.size) {
            this.forwardPacket();
        }
        return true;
    }

    public int[] forwardPacket() {
        if (this.q.isEmpty()) {
            return new int[0];
        }
        int[] temp = this.q.poll();
        ArrayList<int[]> list = this.map.get(temp[1]);
        list.remove(0);
        if (list.isEmpty()) {
            this.map.remove(temp[1]);
        }
        --this.cur;
        return temp;
    }

    public int getCount(int destination, int startTime, int endTime) {
        if (this.map.containsKey(destination)) {
            int i;
            ArrayList<int[]> list = this.map.get(destination);
            int lower = -1;
            int higher = -1;
            for (i = 0; i < list.size(); ++i) {
                if (list.get(i)[1] < startTime) continue;
                lower = i;
                break;
            }
            for (i = list.size() - 1; i >= 0; --i) {
                if (list.get(i)[1] > endTime) continue;
                higher = i;
                break;
            }
            if (lower == -1 || higher == -1) {
                return 0;
            }
            return Math.max(0, higher - lower + 1);
        }
        return 0;
    }
}

