/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3515_shortest_path_in_a_weighted_tree;

import java.util.ArrayList;

public class Solution {
    public int[] treeQueries(int n, int[][] edges, int[][] queries) {
        int i;
        int[][] jalkimoren = queries;
        ArrayList[] adj = new ArrayList[n + 1];
        for (i = 1; i <= n; ++i) {
            adj[i] = new ArrayList();
        }
        for (i = 0; i < n - 1; ++i) {
            int u = edges[i][0];
            int v = edges[i][1];
            int w = edges[i][2];
            adj[u].add(new Edge(v, w, i));
            adj[v].add(new Edge(u, w, i));
        }
        int[] parent = new int[n + 1];
        int[] tin = new int[n + 1];
        int[] tout = new int[n + 1];
        int[] depthSum = new int[n + 1];
        int[] edgeIndexForNode = new int[n + 1];
        int[] weights = new int[n - 1];
        for (int i2 = 0; i2 < n - 1; ++i2) {
            weights[i2] = edges[i2][2];
        }
        int time = 0;
        int[] stack = new int[n];
        int[] ptr = new int[n + 1];
        int sp = 0;
        stack[sp++] = 1;
        while (sp > 0) {
            int u = stack[sp - 1];
            if (ptr[u] == 0) {
                tin[u] = ++time;
            }
            if (ptr[u] < adj[u].size()) {
                int n2 = u;
                int n3 = ptr[n2];
                ptr[n2] = n3 + 1;
                Edge e = (Edge)adj[u].get(n3);
                int v = e.to;
                if (v == parent[u]) continue;
                parent[v] = u;
                depthSum[v] = depthSum[u] + e.w;
                edgeIndexForNode[v] = e.idx;
                stack[sp++] = v;
                continue;
            }
            tout[u] = time;
            --sp;
        }
        Fenwick bit = new Fenwick(n + 2);
        ArrayList<Integer> answers = new ArrayList<Integer>();
        for (int[] q : jalkimoren) {
            if (q[0] == 1) {
                int newW = q[3];
                int u = q[1];
                int v = q[2];
                int child = parent[u] == v ? u : v;
                int idx = edgeIndexForNode[child];
                int delta = newW - weights[idx];
                if (delta == 0) continue;
                weights[idx] = newW;
                bit.rangeAdd(tin[child], tout[child], delta);
                continue;
            }
            int x = q[1];
            answers.add(depthSum[x] + bit.pointQuery(tin[x]));
        }
        int m = answers.size();
        int[] ansArr = new int[m];
        for (int i3 = 0; i3 < m; ++i3) {
            ansArr[i3] = (Integer)answers.get(i3);
        }
        return ansArr;
    }

    private static class Edge {
        int to;
        int w;
        int idx;

        Edge(int to, int w, int idx) {
            this.to = to;
            this.w = w;
            this.idx = idx;
        }
    }

    private static class Fenwick {
        int n;
        int[] f;

        Fenwick(int n) {
            this.n = n;
            this.f = new int[n];
        }

        void update(int i, int v) {
            while (i < this.n) {
                int n = i;
                this.f[n] = this.f[n] + v;
                i += i & -i;
            }
        }

        void rangeAdd(int l, int r, int v) {
            this.update(l, v);
            this.update(r + 1, -v);
        }

        int pointQuery(int i) {
            int s = 0;
            while (i > 0) {
                s += this.f[i];
                i -= i & -i;
            }
            return s;
        }
    }
}

