/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3553_minimum_weighted_subgraph_with_the_required_paths_ii;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Solution {
    private List<int[]>[] graph;
    private int[] euler;
    private int[] depth;
    private int[] firstcome;
    private int[][] sparseT;
    private int times;
    private long[] dists;

    public int[] minimumWeight(int[][] edges, int[][] queries) {
        int p = 0;
        for (int[] e : edges) {
            p = Math.max(p, Math.max(e[0], e[1]));
        }
        this.graph = new ArrayList[++p];
        for (int i = 0; i < p; ++i) {
            this.graph[i] = new ArrayList<int[]>();
        }
        for (int[] e : edges) {
            int u = e[0];
            int v = e[1];
            int w = e[2];
            this.graph[u].add(new int[]{v, w});
            this.graph[v].add(new int[]{u, w});
        }
        int m = 2 * p - 1;
        this.euler = new int[m];
        this.depth = new int[m];
        this.firstcome = new int[p];
        Arrays.fill(this.firstcome, -1);
        this.dists = new long[p];
        this.times = 0;
        this.dfs(0, -1, 0, 0L);
        this.buildSparseTable(m);
        int[] answer = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            int a = queries[i][0];
            int b = queries[i][1];
            int c = queries[i][2];
            long d1 = this.distBetween(a, b);
            long d2 = this.distBetween(b, c);
            long d3 = this.distBetween(a, c);
            answer[i] = (int)((d1 + d2 + d3) / 2L);
        }
        return answer;
    }

    private void dfs(int node, int parent, int d, long distSoFar) {
        this.euler[this.times] = node;
        this.depth[this.times] = d;
        if (this.firstcome[node] == -1) {
            this.firstcome[node] = this.times;
        }
        ++this.times;
        this.dists[node] = distSoFar;
        for (int[] edge : this.graph[node]) {
            int nxt = edge[0];
            int w = edge[1];
            if (nxt == parent) continue;
            this.dfs(nxt, node, d + 1, distSoFar + (long)w);
            this.euler[this.times] = node;
            this.depth[this.times] = d;
            ++this.times;
        }
    }

    private void buildSparseTable(int length) {
        int log = 1;
        while (1 << log <= length) {
            ++log;
        }
        this.sparseT = new int[log][length];
        for (int i = 0; i < length; ++i) {
            this.sparseT[0][i] = i;
        }
        for (int k = 1; k < log; ++k) {
            int i = 0;
            while (i + (1 << k) <= length) {
                int left = this.sparseT[k - 1][i];
                int right = this.sparseT[k - 1][i + (1 << k - 1)];
                this.sparseT[k][i] = this.depth[left] < this.depth[right] ? left : right;
                ++i;
            }
        }
    }

    private int rmq(int l, int r) {
        int right;
        int length;
        int k;
        int left;
        if (l > r) {
            int tmp = l;
            l = r;
            r = tmp;
        }
        return this.depth[left = this.sparseT[k = 31 - Integer.numberOfLeadingZeros(length = r - l + 1)][l]] < this.depth[right = this.sparseT[k][r - (1 << k) + 1]] ? left : right;
    }

    private int lca(int u, int v) {
        int left = this.firstcome[u];
        int right = this.firstcome[v];
        int idx = this.rmq(left, right);
        return this.euler[idx];
    }

    private long distBetween(int u, int v) {
        int ancestor = this.lca(u, v);
        return this.dists[u] + this.dists[v] - 2L * this.dists[ancestor];
    }
}

