/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3569_maximize_count_of_distinct_primes_after_split;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class Solution {
    private static final int MAX_VAL = 100005;
    private static boolean[] isPrime = new boolean[100005];

    public int[] maximumCount(int[] nums, int[][] queries) {
        int n = nums.length;
        HashMap<Integer, TreeSet> primeIndices = new HashMap<Integer, TreeSet>();
        for (int i = 0; i < n; ++i) {
            if (!isPrime[nums[i]]) continue;
            primeIndices.computeIfAbsent(nums[i], k -> new TreeSet()).add(i);
        }
        SegmentTree segmentTree = new SegmentTree(n);
        for (Map.Entry entry : primeIndices.entrySet()) {
            TreeSet indices = (TreeSet)entry.getValue();
            int first = (Integer)indices.first();
            int last = (Integer)indices.last();
            segmentTree.update(first + 1, last, 1);
        }
        int[] result = new int[queries.length];
        for (int q = 0; q < queries.length; ++q) {
            int idx = queries[q][0];
            int val = queries[q][1];
            int oldVal = nums[idx];
            if (isPrime[oldVal]) {
                TreeSet indices = (TreeSet)primeIndices.get(oldVal);
                int oldFirst = (Integer)indices.first();
                int oldLast = (Integer)indices.last();
                indices.remove(idx);
                if (indices.isEmpty()) {
                    primeIndices.remove(oldVal);
                    segmentTree.update(oldFirst + 1, oldLast, -1);
                } else {
                    int newFirst = (Integer)indices.first();
                    int newLast = (Integer)indices.last();
                    if (idx == oldFirst && newFirst != oldFirst) {
                        segmentTree.update(oldFirst + 1, newFirst, -1);
                    }
                    if (idx == oldLast && newLast != oldLast) {
                        segmentTree.update(newLast + 1, oldLast, -1);
                    }
                }
            }
            nums[idx] = val;
            if (isPrime[val]) {
                boolean wasNewPrime = !primeIndices.containsKey(val);
                TreeSet indices = primeIndices.computeIfAbsent(val, k -> new TreeSet());
                int oldFirst = indices.isEmpty() ? -1 : (Integer)indices.first();
                int oldLast = indices.isEmpty() ? -1 : (Integer)indices.last();
                indices.add(idx);
                int newFirst = (Integer)indices.first();
                int newLast = (Integer)indices.last();
                if (wasNewPrime) {
                    segmentTree.update(newFirst + 1, newLast, 1);
                } else {
                    if (idx < oldFirst) {
                        segmentTree.update(newFirst + 1, oldFirst, 1);
                    }
                    if (idx > oldLast) {
                        segmentTree.update(oldLast + 1, newLast, 1);
                    }
                }
            }
            int totalDistinctPrimesInCurrentNums = primeIndices.size();
            int maxIntersection = segmentTree.queryMax();
            maxIntersection = Math.max(0, maxIntersection);
            result[q] = totalDistinctPrimesInCurrentNums + maxIntersection;
        }
        return result;
    }

    static {
        Arrays.fill(isPrime, true);
        Solution.isPrime[1] = false;
        Solution.isPrime[0] = false;
        int i = 2;
        while (i * i < 100005) {
            if (isPrime[i]) {
                for (int j = i * i; j < 100005; j += i) {
                    Solution.isPrime[j] = false;
                }
            }
            ++i;
        }
    }

    private static class SegmentTree {
        Node[] tree;
        int n;

        public SegmentTree(int n) {
            this.n = n;
            this.tree = new Node[4 * this.n];
            for (int i = 0; i < 4 * this.n; ++i) {
                this.tree[i] = new Node();
            }
        }

        private void push(int nodeIdx) {
            if (this.tree[nodeIdx].lazyDelta != 0) {
                this.tree[2 * nodeIdx].maxVal += this.tree[nodeIdx].lazyDelta;
                this.tree[2 * nodeIdx].lazyDelta += this.tree[nodeIdx].lazyDelta;
                this.tree[2 * nodeIdx + 1].maxVal += this.tree[nodeIdx].lazyDelta;
                this.tree[2 * nodeIdx + 1].lazyDelta += this.tree[nodeIdx].lazyDelta;
                this.tree[nodeIdx].lazyDelta = 0;
            }
        }

        private void update(int queryStart, int queryEnd, int delta) {
            if ((queryStart = Math.max(1, queryStart)) > (queryEnd = Math.min(this.n - 1, queryEnd))) {
                return;
            }
            this.update(1, 1, this.n - 1, queryStart, queryEnd, delta);
        }

        private void update(int nodeIdx, int start, int end, int queryStart, int queryEnd, int delta) {
            if (start > end || start > queryEnd || end < queryStart) {
                return;
            }
            if (queryStart <= start && end <= queryEnd) {
                this.tree[nodeIdx].maxVal += delta;
                this.tree[nodeIdx].lazyDelta += delta;
                return;
            }
            this.push(nodeIdx);
            int mid = (start + end) / 2;
            this.update(2 * nodeIdx, start, mid, queryStart, queryEnd, delta);
            this.update(2 * nodeIdx + 1, mid + 1, end, queryStart, queryEnd, delta);
            this.tree[nodeIdx].maxVal = Math.max(this.tree[2 * nodeIdx].maxVal, this.tree[2 * nodeIdx + 1].maxVal);
        }

        public int queryMax() {
            if (this.n - 1 < 1) {
                return 0;
            }
            return this.tree[1].maxVal;
        }
    }

    private static class Node {
        int maxVal;
        int lazyDelta;

        private Node() {
        }
    }
}

