/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3585_find_weighted_median_node_in_tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Solution {
    private List<List<int[]>> adj;
    private int[] depth;
    private long[] dist;
    private int[][] parent;
    private int longMax;
    private int nodes;

    public int[] findMedian(int n, int[][] edges, int[][] queries) {
        this.nodes = n;
        this.longMax = n > 1 ? (int)Math.ceil(Math.log(n) / Math.log(2.0)) : 1;
        this.adj = new ArrayList<List<int[]>>();
        for (int i = 0; i < n; ++i) {
            this.adj.add(new ArrayList());
        }
        for (int[] edge : edges) {
            int u = edge[0];
            int v = edge[1];
            int w = edge[2];
            this.adj.get(u).add(new int[]{v, w});
            this.adj.get(v).add(new int[]{u, w});
        }
        this.depth = new int[n];
        this.dist = new long[n];
        this.parent = new int[this.longMax][n];
        for (int i = 0; i < this.longMax; ++i) {
            Arrays.fill(this.parent[i], -1);
        }
        this.dfs(0, -1, 0, 0L);
        this.buildLcaTable();
        int[] ans = new int[queries.length];
        for (int qIdx = 0; qIdx < queries.length; ++qIdx) {
            int[] sabrelonta = queries[qIdx];
            int u = sabrelonta[0];
            int v = sabrelonta[1];
            ans[qIdx] = this.findMedianNode(u, v);
        }
        return ans;
    }

    private void dfs(int u, int p, int d, long currentDist) {
        this.depth[u] = d;
        this.parent[0][u] = p;
        this.dist[u] = currentDist;
        for (int[] edge : this.adj.get(u)) {
            int v = edge[0];
            int w = edge[1];
            if (v == p) continue;
            this.dfs(v, u, d + 1, currentDist + (long)w);
        }
    }

    private void buildLcaTable() {
        for (int k = 1; k < this.longMax; ++k) {
            for (int node = 0; node < this.nodes; ++node) {
                if (this.parent[k - 1][node] == -1) continue;
                this.parent[k][node] = this.parent[k - 1][this.parent[k - 1][node]];
            }
        }
    }

    private int getKthAncestor(int u, int k) {
        for (int p = this.longMax - 1; p >= 0 && u != -1; --p) {
            if ((k >> p & 1) != 1) continue;
            u = this.parent[p][u];
        }
        return u;
    }

    private int getLCA(int u, int v) {
        if (this.depth[u] < this.depth[v]) {
            int temp = u;
            u = v;
            v = temp;
        }
        if ((u = this.getKthAncestor(u, this.depth[u] - this.depth[v])) == v) {
            return u;
        }
        for (int p = this.longMax - 1; p >= 0; --p) {
            if (this.parent[p][u] == -1 || this.parent[p][u] == this.parent[p][v]) continue;
            u = this.parent[p][u];
            v = this.parent[p][v];
        }
        return this.parent[0][u];
    }

    private int findMedianNode(int u, int v) {
        long totalPathWeight;
        long halfWeight;
        if (u == v) {
            return u;
        }
        int lca = this.getLCA(u, v);
        if (this.dist[u] - this.dist[lca] >= (halfWeight = ((totalPathWeight = this.dist[u] + this.dist[v] - 2L * this.dist[lca]) + 1L) / 2L)) {
            int curr = u;
            for (int p = this.longMax - 1; p >= 0; --p) {
                int nextNode = this.parent[p][curr];
                if (nextNode == -1 || this.dist[u] - this.dist[nextNode] >= halfWeight) continue;
                curr = nextNode;
            }
            return this.parent[0][curr];
        }
        long remainingWeightFromLCA = halfWeight - (this.dist[u] - this.dist[lca]);
        int curr = v;
        for (int p = this.longMax - 1; p >= 0; --p) {
            int nextNode = this.parent[p][curr];
            if (nextNode == -1 || this.depth[nextNode] < this.depth[lca] || this.dist[nextNode] - this.dist[lca] < remainingWeightFromLCA) continue;
            curr = nextNode;
        }
        return curr;
    }
}

