/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3590_kth_smallest_path_xor_sum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class Solution {
    private List<List<Integer>> adj;
    private int[] xors;
    private int[] subtreeSize;
    private int[] postorderIndex;
    private OrderStatisticSet[] nodeSets;
    private List<int[]> queries;
    private int[] result;
    private int time = 0;
    private int queryPtr = 0;

    public int[] kthSmallest(int[] parent, int[] vals, int[][] rawQueries) {
        int i;
        int n = parent.length;
        this.adj = new ArrayList<List<Integer>>();
        for (i = 0; i < n; ++i) {
            this.adj.add(new ArrayList());
        }
        this.xors = new int[n];
        this.subtreeSize = new int[n];
        this.postorderIndex = new int[n];
        this.nodeSets = new OrderStatisticSet[n];
        for (i = 1; i < n; ++i) {
            this.adj.get(parent[i]).add(i);
        }
        this.computeSubtreeInfo(0, vals[0], vals);
        this.queries = new ArrayList<int[]>();
        i = 0;
        while (i < rawQueries.length) {
            this.queries.add(new int[]{rawQueries[i][0], rawQueries[i][1], i++});
        }
        this.queries.sort(Comparator.comparingInt(a -> this.postorderIndex[a[0]]));
        this.result = new int[this.queries.size()];
        this.dfs(0);
        return this.result;
    }

    private void computeSubtreeInfo(int node, int currentXor, int[] vals) {
        this.xors[node] = currentXor;
        int size = 1;
        for (int child : this.adj.get(node)) {
            this.computeSubtreeInfo(child, currentXor ^ vals[child], vals);
            size += this.subtreeSize[child];
        }
        this.subtreeSize[node] = size;
        ++this.time;
    }

    private void dfs(int node) {
        int largestChild = -1;
        int maxSize = -1;
        for (int child : this.adj.get(node)) {
            this.dfs(child);
            if (this.subtreeSize[child] <= maxSize) continue;
            maxSize = this.subtreeSize[child];
            largestChild = child;
        }
        this.nodeSets[node] = largestChild == -1 ? new OrderStatisticSet() : this.nodeSets[largestChild];
        this.nodeSets[node].insert(this.xors[node]);
        for (int child : this.adj.get(node)) {
            if (child == largestChild) continue;
            this.nodeSets[node].insertAll(this.nodeSets[child]);
        }
        while (this.queryPtr < this.queries.size() && this.queries.get(this.queryPtr)[0] == node) {
            int k = this.queries.get(this.queryPtr)[1];
            int queryId = this.queries.get(this.queryPtr)[2];
            this.result[queryId] = this.nodeSets[node].size() >= k ? this.nodeSets[node].findByOrder(k - 1) : -1;
            ++this.queryPtr;
        }
    }

    private static class OrderStatisticSet {
        private final TreeSet<Integer> set = new TreeSet();
        private final ArrayList<Integer> list = new ArrayList();

        private OrderStatisticSet() {
        }

        public void insert(int x) {
            if (this.set.add(x)) {
                int pos = Collections.binarySearch(this.list, x);
                if (pos < 0) {
                    pos = -(pos + 1);
                }
                this.list.add(pos, x);
            }
        }

        public void insertAll(OrderStatisticSet other) {
            for (int val : other.list) {
                this.insert(val);
            }
        }

        public int size() {
            return this.set.size();
        }

        public int findByOrder(int k) {
            return this.list.get(k);
        }
    }
}

