/*
 * Decompiled with CFR 0.152.
 */
package g3601_3700.s3605_minimum_stability_factor_of_array;

public class Solution {
    public int minStable(int[] nums, int maxC) {
        int n = nums.length;
        int cnt = 0;
        for (int idx = 0; idx < n; ++idx) {
            cnt += nums[idx] >= 2 ? 1 : 0;
        }
        if (cnt <= maxC) {
            return 0;
        }
        int[] logs = new int[n + 1];
        int maxLog = 0;
        for (int temp = n; temp > 0; temp >>= 1) {
            ++maxLog;
        }
        int[][] table = new int[maxLog + 1][n];
        this.buildLogs(logs, n);
        this.buildTable(table, nums, n, maxLog);
        return this.binarySearch(nums, maxC, n, logs, table);
    }

    private void buildLogs(int[] logs, int n) {
        for (int i = 2; i <= n; ++i) {
            logs[i] = logs[i >> 1] + 1;
        }
    }

    private void buildTable(int[][] table, int[] nums, int n, int maxLog) {
        System.arraycopy(nums, 0, table[0], 0, n);
        for (int level = 1; level <= maxLog; ++level) {
            int start = 0;
            while (start + (1 << level) <= n) {
                table[level][start] = this.gcd(table[level - 1][start], table[level - 1][start + (1 << level - 1)]);
                ++start;
            }
        }
    }

    private int binarySearch(int[] nums, int maxC, int n, int[] logs, int[][] table) {
        int left = 1;
        int right = n;
        int result = n;
        while (left <= right) {
            int mid = left + (right - left >> 1);
            boolean valid = this.isValid(nums, maxC, mid, logs, table);
            result = valid ? mid : result;
            int newLeft = valid ? left : mid + 1;
            int newRight = valid ? mid - 1 : right;
            left = newLeft;
            right = newRight;
        }
        return result;
    }

    private boolean isValid(int[] arr, int limit, int segLen, int[] logs, int[][] table) {
        int n = arr.length;
        int window = segLen + 1;
        int cuts = 0;
        int prevCut = -1;
        int pos = 0;
        while (pos + window - 1 < n && cuts <= limit) {
            int rangeGcd = this.getRangeGcd(pos, pos + window - 1, logs, table);
            if (rangeGcd >= 2) {
                boolean shouldCut = prevCut < pos;
                cuts += shouldCut ? 1 : 0;
                prevCut = shouldCut ? pos + window - 1 : prevCut;
            }
            ++pos;
        }
        return cuts <= limit;
    }

    private int getRangeGcd(int left, int right, int[] logs, int[][] table) {
        int k = logs[right - left + 1];
        return this.gcd(table[k][left], table[k][right - (1 << k) + 1]);
    }

    private int gcd(int a, int b) {
        return b == 0 ? a : this.gcd(b, a % b);
    }
}

