/*
 * Decompiled with CFR 0.152.
 */
package g3601_3700.s3607_power_grid_maintenance;

import java.util.ArrayList;
import java.util.PriorityQueue;

public class Solution {
    public int[] processQueries(int c, int[][] connections, int[][] queries) {
        UF uf = new UF(c);
        for (int[] con : connections) {
            int u = con[0];
            int v = con[1];
            uf.union(u - 1, v - 1);
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int[] q : queries) {
            if (q[0] == 1) {
                res.add(uf.check(q[1] - 1) + 1);
                continue;
            }
            uf.inactive(q[1] - 1);
        }
        return res.stream().mapToInt(Integer::intValue).toArray();
    }

    private static class UF {
        int[] par;
        PriorityQueue<Integer>[] pq;
        boolean[] active;

        UF(int n) {
            this.par = new int[n];
            this.pq = new PriorityQueue[n];
            this.active = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this.active[i] = true;
                this.par[i] = i;
                this.pq[i] = new PriorityQueue();
                this.pq[i].add(i);
            }
        }

        int find(int u) {
            if (this.par[u] == u) {
                return u;
            }
            this.par[u] = this.find(this.par[u]);
            return this.par[u];
        }

        void union(int u, int v) {
            int pv;
            int pu = this.find(u);
            if (pu == (pv = this.find(v))) {
                return;
            }
            if (this.pq[pu].size() > this.pq[pv].size()) {
                while (!this.pq[pv].isEmpty()) {
                    this.pq[pu].add(this.pq[pv].poll());
                }
                this.par[pv] = this.par[pu];
            } else {
                while (!this.pq[pu].isEmpty()) {
                    this.pq[pv].add(this.pq[pu].poll());
                }
                this.par[pu] = this.par[pv];
            }
        }

        void inactive(int u) {
            this.active[u] = false;
        }

        int check(int u) {
            if (this.active[u]) {
                return u;
            }
            int pu = this.find(u);
            while (!this.pq[pu].isEmpty() && !this.active[this.pq[pu].peek()]) {
                this.pq[pu].poll();
            }
            return !this.pq[pu].isEmpty() ? this.pq[pu].peek() : -2;
        }
    }
}

