/*
 * Decompiled with CFR 0.152.
 */
package g3601_3700.s3620_network_recovery_pathways;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Solution {
    private List<Integer> topologicalSort(int n, List<List<Integer>> g) {
        int[] indeg = new int[n];
        for (int i = 0; i < n; ++i) {
            Iterator<Integer> iterator = g.get(i).iterator();
            while (iterator.hasNext()) {
                int adjNode;
                int n2 = adjNode = iterator.next().intValue();
                indeg[n2] = indeg[n2] + 1;
            }
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        ArrayList<Integer> ts = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (indeg[i] != 0) continue;
            q.offer(i);
        }
        while (!q.isEmpty()) {
            int u = (Integer)q.poll();
            ts.add(u);
            Iterator<Integer> iterator = g.get(u).iterator();
            while (iterator.hasNext()) {
                int v;
                int n3 = v = iterator.next().intValue();
                indeg[n3] = indeg[n3] - 1;
                if (indeg[v] != 0) continue;
                q.offer(v);
            }
        }
        return ts;
    }

    private boolean check(int x, int n, List<List<int[]>> adj, List<Integer> ts, boolean[] online, long k) {
        long[] d = new long[n];
        Arrays.fill(d, Long.MAX_VALUE);
        d[0] = 0L;
        for (int u : ts) {
            if (d[u] == Long.MAX_VALUE) continue;
            for (int[] p : adj.get(u)) {
                int v = p[0];
                int c = p[1];
                if (c < x || !online[v] || d[u] + (long)c >= d[v]) continue;
                d[v] = d[u] + (long)c;
            }
        }
        return d[n - 1] <= k;
    }

    public int findMaxPathScore(int[][] edges, boolean[] online, long k) {
        int n = online.length;
        ArrayList<List<int[]>> adj = new ArrayList<List<int[]>>();
        for (int i = 0; i < n; ++i) {
            adj.add(new ArrayList());
        }
        ArrayList<List<Integer>> g = new ArrayList<List<Integer>>();
        for (int i = 0; i < n; ++i) {
            g.add(new ArrayList());
        }
        for (int[] nArray : edges) {
            int u = nArray[0];
            int v = nArray[1];
            int c = nArray[2];
            ((List)adj.get(u)).add(new int[]{v, c});
            ((List)g.get(u)).add(v);
        }
        List<Integer> ts = this.topologicalSort(n, g);
        if (!this.check(0, n, adj, ts, online, k)) {
            return -1;
        }
        int l = 0;
        int h = 0;
        for (int[] e : edges) {
            h = Math.max(h, e[2]);
        }
        while (l < h) {
            int n2 = l + (h - l + 1) / 2;
            if (this.check(n2, n, adj, ts, online, k)) {
                l = n2;
                continue;
            }
            h = n2 - 1;
        }
        return l;
    }
}

