/*
 * Decompiled with CFR 0.152.
 */
package g3601_3700.s3650_minimum_cost_path_with_edge_reversals;

import java.util.Arrays;
import java.util.PriorityQueue;

public class Solution {
    private static final int INF = 0x3FFFFFFE;
    private int cnt;
    private int[] head;
    private int[] next;
    private int[] to;
    private int[] weight;

    private void init(int n, int m) {
        this.head = new int[n];
        Arrays.fill(this.head, -1);
        this.next = new int[m];
        this.to = new int[m];
        this.weight = new int[m];
    }

    private void add(int u, int v, int w) {
        this.to[this.cnt] = v;
        this.weight[this.cnt] = w;
        this.next[this.cnt] = this.head[u];
        ++this.cnt;
    }

    private int dist(int s, int t, int n) {
        PriorityQueue<Dist> queue = new PriorityQueue<Dist>();
        int[] dist = new int[n];
        Arrays.fill(dist, 0x3FFFFFFE);
        dist[s] = 0;
        queue.add(new Dist(s, dist[s]));
        while (!queue.isEmpty()) {
            Dist d = (Dist)queue.remove();
            int u = d.u;
            if (dist[u] < d.d) continue;
            if (u == t) {
                return dist[t];
            }
            int i = this.head[u];
            while (i != -1) {
                int v = this.to[i];
                int w = this.weight[i];
                if (dist[v] > dist[u] + w) {
                    dist[v] = dist[u] + w;
                    queue.add(new Dist(v, dist[v]));
                }
                i = this.next[i];
            }
        }
        return 0x3FFFFFFE;
    }

    public int minCost(int n, int[][] edges) {
        int m = edges.length;
        this.init(n, 2 * m);
        for (int[] edge : edges) {
            int u = edge[0];
            int v = edge[1];
            int w = edge[2];
            this.add(u, v, w);
            this.add(v, u, 2 * w);
        }
        int ans = this.dist(0, n - 1, n);
        return ans == 0x3FFFFFFE ? -1 : ans;
    }

    private static class Dist
    implements Comparable<Dist> {
        int u;
        int d;

        public Dist(int u, int d) {
            this.u = u;
            this.d = d;
        }

        @Override
        public int compareTo(Dist o) {
            return Long.compare(this.d, o.d);
        }
    }
}

