/*
 * Decompiled with CFR 0.152.
 */
package g3501_3600.s3501_maximize_active_section_with_trade_ii;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Solution {
    private static final int INF = 1000000000;
    private static final int NEG_INF = -1000000000;

    public List<Integer> maxActiveSectionsAfterTrade(String s, int[][] queries) {
        int i;
        int n = s.length();
        int activeCount = 0;
        for (char ch : s.toCharArray()) {
            if (ch != '1') continue;
            ++activeCount;
        }
        ArrayList<int[]> segments = new ArrayList<int[]>();
        int start = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 != n - 1 && s.charAt(i2) == s.charAt(i2 + 1)) continue;
            segments.add(new int[]{start, i2 - start + 1});
            start = i2 + 1;
        }
        int segmentCount = segments.size();
        int maxPower = 20;
        int[][] rmq = new int[maxPower][segmentCount];
        for (i = 0; i < maxPower; ++i) {
            Arrays.fill(rmq[i], -1000000000);
        }
        for (i = 0; i < segmentCount; ++i) {
            if (s.charAt(((int[])segments.get(i))[0]) != '0' || i + 2 >= segmentCount) continue;
            rmq[0][i] = ((int[])segments.get(i))[1] + ((int[])segments.get(i + 2))[1];
        }
        int power = 1;
        int rangeLen = 2;
        while (power < maxPower) {
            int i3 = 0;
            for (int j = rangeLen - 1; j < segmentCount; ++j) {
                rmq[power][i3] = Math.max(rmq[power - 1][i3], rmq[power - 1][i3 + rangeLen / 2]);
                ++i3;
            }
            ++power;
            rangeLen *= 2;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int[] query : queries) {
            int left = query[0];
            int right = query[1];
            int leftIndex = this.binarySearch(segments, left) - 1;
            int rightIndex = this.binarySearch(segments, right) - 1;
            if (rightIndex - leftIndex + 1 <= 2) {
                result.add(activeCount);
                continue;
            }
            int bestIncrease = Math.max(this.getMaxInRange(rmq, leftIndex + 1, rightIndex - 3), 0);
            bestIncrease = Math.max(bestIncrease, this.calculateNewSections(s, segments, left, right, leftIndex, rightIndex, leftIndex));
            bestIncrease = Math.max(bestIncrease, this.calculateNewSections(s, segments, left, right, leftIndex, rightIndex, rightIndex - 2));
            result.add(activeCount + bestIncrease);
        }
        return result;
    }

    private int binarySearch(List<int[]> segments, int key) {
        int lo = 0;
        int hi = segments.size();
        while (lo < hi) {
            int mid = lo + (hi - lo) / 2;
            if (segments.get(mid)[0] > key) {
                hi = mid;
                continue;
            }
            lo = mid + 1;
        }
        return lo;
    }

    private int getMaxInRange(int[][] rmq, int left, int right) {
        if (left > right) {
            return -1000000000;
        }
        int power = 31 - Integer.numberOfLeadingZeros(right - left + 1);
        return Math.max(rmq[power][left], rmq[power][right - (1 << power) + 1]);
    }

    private int getSegmentSize(List<int[]> segments, int left, int right, int leftIndex, int rightIndex, int i) {
        if (i == leftIndex) {
            return segments.get(leftIndex)[1] - (left - segments.get(leftIndex)[0]);
        }
        if (i == rightIndex) {
            return right - segments.get(rightIndex)[0] + 1;
        }
        return segments.get(i)[1];
    }

    private int calculateNewSections(String s, List<int[]> segments, int left, int right, int leftIndex, int rightIndex, int i) {
        if (i < 0 || i + 2 >= segments.size() || s.charAt(segments.get(i)[0]) == '1') {
            return -1000000000;
        }
        int size1 = this.getSegmentSize(segments, left, right, leftIndex, rightIndex, i);
        int size2 = this.getSegmentSize(segments, left, right, leftIndex, rightIndex, i + 2);
        return size1 + size2;
    }
}

