/*
 * Decompiled with CFR 0.152.
 */
package g1501_1600.s1600_throne_inheritance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThroneInheritance {
    private String king;
    private HashMap<String, LinkedHashSet<String>> graph;
    private HashSet<String> isDead;

    public ThroneInheritance(String kingName) {
        this.king = kingName;
        this.graph = new HashMap();
        this.isDead = new HashSet();
        this.graph.put(kingName, new LinkedHashSet());
    }

    public void birth(String parentName, String childName) {
        this.graph.putIfAbsent(parentName, new LinkedHashSet());
        this.graph.get(parentName).add(childName);
    }

    public void death(String name) {
        this.isDead.add(name);
    }

    public List<String> getInheritanceOrder() {
        ArrayList<String> inheritance = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        this.dfs(this.graph, this.king, inheritance, visited);
        return inheritance;
    }

    public void dfs(Map<String, LinkedHashSet<String>> graph, String src, List<String> l, Set<String> visited) {
        visited.add(src);
        if (!this.isDead.contains(src)) {
            l.add(src);
        }
        if (!graph.containsKey(src)) {
            return;
        }
        for (String s : graph.get(src)) {
            if (visited.contains(s)) continue;
            this.dfs(graph, s, l, visited);
        }
    }
}

